from mock import MagicMock
import unittest
from surly import Surly
import inspect
from test_helper import TestHelper


class BackupHostTest(TestHelper):

    def setUp(self):
        super(BackupHostTest, self).setUp()
        self.host = 'example.com'
        self.toolbar_id = 'AA001753'

    def _get_data(self, method_name, type):
        self.test_name = 'backup_host'
        return super(BackupHostTest, self)._get_data(method_name, type)

    def test_request_root_status(self):
        surly = Surly()
        self.assertEqual(
            'GOOD',
            surly._perform_request(
                surly.api_host + surly.api_root_status_path
            ),
            'Failure! Please, first check root status of server and then check your code.'
        )

    def test_use_backup_host(self):
        this_method_name = inspect.stack()[0][3]
        surly = Surly(toolbar_id=self.toolbar_id)
        surly._check_is_root_domain_alive_remotely = MagicMock(return_value=False)
        surly.is_root_domain_alive = None

        self.assertEqual(
            surly.process(self._get_data(this_method_name, 'in')),
            self._get_data(this_method_name, 'expected'),
        )

    def test_root_status_api_not_available(self):
        this_method_name = inspect.stack()[0][3]
        surly = Surly(toolbar_id=self.toolbar_id)
        surly.api_host = 'asdfasdfasdfasdfasdfasdfasdfadfasdfasdfasdf.com'

        self.assertEqual(
            surly.process(self._get_data(this_method_name, 'in')),
            self._get_data(this_method_name, 'expected'),
        )


if __name__ == '__main__':
    unittest.main()