﻿// Copyright (c) 2012-2015 Sur.ly
// This file is part of Sur.ly SDK.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 3 of the
// License, or (at your option) any later version.
//
// You should have received a copy of the GNU Lesser General Public License
// along with Sur.ly SDK. If not, see http://www.gnu.org/licenses/

using System.Web;

namespace SurlyCore
{
    public class SurlyModule : IHttpModule
    {
        public void Init(HttpApplication context)
        {
            if (Surly.HtmlParsingEnabled)
                context.PostRequestHandlerExecute += (o, e) =>
                {
                    HttpContext httpContext = ((HttpApplication)o).Context;
                    HttpResponse response = httpContext.Response;

                    // Don't interfere with non-HTML responses
                    if (response.ContentType == "text/html")
                    {
                        response.Filter = new InternalStream(response.Filter);
                    }
                };
        }
        public void Dispose()
        {
        }
    }
}