﻿// Copyright (c) 2012-2015 Sur.ly
// This file is part of Sur.ly SDK.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 3 of the
// License, or (at your option) any later version.
//
// You should have received a copy of the GNU Lesser General Public License
// along with Sur.ly SDK. If not, see http://www.gnu.org/licenses/

using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Text.RegularExpressions;

namespace SurlyCore
{
    public class LinkFinder
    {
        public List<LinkModel> FindLinks(string dataContent)
        {
            var existingLinks = new List<LinkModel>();

            try
            {
                var dataResult = Regex.Match(dataContent, "href\\s*=\\s*(?:[\"'](?<1>[^\"']*)[\"']|(?<1>\\S+))",
                    RegexOptions.Compiled | RegexOptions.IgnoreCase);

                while (dataResult.Success)
                {
                    existingLinks.Add(new LinkModel
                    {
                        Url = dataResult.Groups[1].Value,
                        Length =  dataResult.Groups[1].Length,
                        Index = dataResult.Groups[1].Index
                    });
                    dataResult = dataResult.NextMatch();
                }
            }
            catch (Exception ex)
            {
                Debug.WriteLine(ex.ToString());
                Trace.WriteLine(ex.ToString());
            }

            return existingLinks;
        }
    }
}