﻿// Copyright (c) 2012-2015 Sur.ly
// This file is part of Sur.ly SDK.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 3 of the
// License, or (at your option) any later version.
//
// You should have received a copy of the GNU Lesser General Public License
// along with Sur.ly SDK. If not, see http://www.gnu.org/licenses/

using System.IO;
using System.Text;

namespace SurlyCore
{
    public class InternalStream : Stream
    {
        private const int UsefullInfoLimit = 5;

        private readonly Stream _buffer;
        public InternalStream(Stream stream)
        {
            _buffer = stream;
        }
        public override void Flush()
        {
            _buffer.Flush();
        }

        public override long Seek(long offset, SeekOrigin origin)
        {
            return _buffer.Seek(offset, origin);
        }

        public override void SetLength(long value)
        {
            _buffer.SetLength(value);
        }

        public override int Read(byte[] buffer, int offset, int count)
        {
            return _buffer.Read(buffer, offset, count);
        }

        public override void Write(byte[] buffer, int offset, int count)
        {
            if (buffer.Length > UsefullInfoLimit)
            {
                var stringToParse = Encoding.UTF8.GetString(buffer, offset, count);
                stringToParse = Surly.Process(stringToParse);
                var data = Encoding.UTF8.GetBytes(stringToParse);
                _buffer.Write(data, offset, data.Length);
            }
            else
            {
                _buffer.Write(buffer, 0, count);
            }
        }

        public override bool CanRead
        {
            get { return _buffer.CanRead; }
        }

        public override bool CanSeek
        {
            get { return _buffer.CanSeek; }
        }

        public override bool CanWrite
        {
            get { return _buffer.CanWrite; }
        }

        public override long Length
        {
            get { return _buffer.Length; }
        }

        public override long Position { get; set; }
    }
}