<?php
/*
 * Copyright (c) 2012-2017 Sur.ly
 * This file is part of Sur.ly vBulletin plugin.
 *
 * Sur.ly vBulletin plugin plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Sur.ly vBulletin plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Sur.ly vBulletin plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

if (!isset($GLOBALS['vbulletin']->db))
{
	exit;
}

require_once(DIR . '/packages/surly/surly-sdk-php/surly/Surly.php');

define('SURLY_ACTION_TYPE_INSTALL', 1);
define('SURLY_ACTION_TYPE_AUTH', 2);
define('SURLY_ACTION_TYPE_ACTIVATION', 3);
define('SURLY_ACTION_TYPE_DEACTIVATION', 4);
define('SURLY_ACTION_TYPE_UNINSTALL', 5);
define('SURLY_ACTION_TYPE_SUBDOMAIN_LINK', 6);
define('SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK', 7);

class vB_Surly extends Surly
{
	var $registry = null;
	var $isRootDomainAlive = null;

	function vB_Surly($registry)
	{
		if (is_object($registry))
		{
			$this->registry = $registry;

			if ($this->registry->options['surly_subdomain']) {
				$this->setPanelHost($this->registry->options['surly_subdomain']);
			}

			$surly_trusted_domains = json_decode($this->registry->options['surly_trusted_domains'], true);

			foreach ($surly_trusted_domains as $domain) {
				$this->whitelist($domain);
			}

			$base_url = parse_url(VB_URL_WEBROOT, PHP_URL_HOST);

			$this->whitelist( $base_url );

			parent::__construct($this->registry->options['surly_toolbar_id'], $this->registry->options['surly_shorten_urls']);
		}
	}

	function _hex2raw($hash)
	{
		$result = '';

		for ($i = 0; $i < 32; $i += 2)
		{
			$result .= chr(hexdec(substr($hash, $i, 2)));
		}

		return $result;
	}

	function _hashUrl($url)
	{
		if (empty($url) || !is_string($url))
		{
			return false;
		}

		if (version_compare(PHP_VERSION, '5.0.0', '>='))
		{
			return md5($url, true);
		}
		else
		{
			return $this->_hex2raw(md5($url));
		}
	}

	function cacheShortIds($UrlIdPairs)
	{
		$values = array();

		foreach ($UrlIdPairs as $url => $id)
		{
			if (!$url || !$id)
			{
				continue;
			}

			$hash = $this->_hashUrl($url);

			if (!$hash)
			{
				continue;
			}

			$url = $this->registry->db->escape_string($url);
			$hash = $this->registry->db->escape_string($hash);
			$id = $this->registry->db->escape_string($id);

			$values[] = "('$url', '$hash', '$id')";
		}

		if (empty($values))
		{
			return;
		}

		$values = implode(', ', $values);

		$this->registry->db->query_write("
			INSERT IGNORE INTO " . TABLE_PREFIX . "surlycache
				(long_url, hash, short_id)
			VALUES
				$values
		");
	}

	function getCachedShortIds($urls)
	{
		$where = array();

		foreach ($urls as $url)
		{
			$hash = $this->_hashUrl($url);

			if (!$hash)
			{
				continue;
			}

			$hash = $this->registry->db->escape_string($hash);
			$url = $this->registry->db->escape_string($url);

			$where[] = "(hash = '$hash' AND long_url = '$url')";
		}

		if (empty($where))
		{
			return array();
		}

		$where = implode(" OR ", $where);

		$result = array();

		$query_result = $this->registry->db->query_read_slave("
			SELECT long_url, short_id
			FROM " . TABLE_PREFIX . "surlycache
			WHERE $where
		");

		while ($row = $this->registry->db->fetch_array($query_result))
		{
			$result[$row['long_url']] = $row['short_id'];
		}

		$this->registry->db->free_result($query_result);

		return $result;
	}

	function cacheRootStatus($rootStatus)
	{
		build_datastore('surly_rootstatus', $rootStatus, 0);

		$this->registry->datastore->register('surly_rootstatus', $rootStatus, 0);
	}

	function getCachedRootStatus()
	{
		if (empty($this->registry->surly_rootstatus))
		{
			$this->registry->datastore->fetch(array('surly_rootstatus'));
		}

		return iif(empty($this->registry->surly_rootstatus), false, $this->registry->surly_rootstatus);
	}

	function processByUserId($html, $userid = null)
	{
		$userinfo = fetch_userinfo($userid);
		$usergroups = (array) $userinfo['usergroupid'];

		$surly_trusted_groups = json_decode($this->registry->options['surly_trusted_groups'], true);

		return in_array($userinfo['usergroupid'], $surly_trusted_groups)
			? $html : parent::process($html);
	}

	function trackHistory($actionType)
	{
		$this->timeout = SURLY_API_TRACK_TIMEOUT;

		$this->_performRequest(
			$this->apiHost . SURLY_API_TRACK_HISTORY_PATH,  'POST',
				array(
					'action_type' => $actionType,
					'site_url' => VB_URL_WEBROOT,
					'toolbar_id' => $this->registry->options['surly_toolbar_id'],
					'hash' => $this->registry->options['surly_activation_hash'],
				)
		);

		$this->timeout = SURLY_API_TIMEOUT;
	}

	function linkSubdomain($subdomain)
	{
		return $this->_performRequest(
			$this->apiHost . SURLY_API_SUBDOMAIN_LINK, 'POST',
				array(
					'toolbar_id' => $this->registry->options['surly_toolbar_id'],
					'password' => $this->registry->options['surly_toolbar_password'],
					'subdomain' => $subdomain,
				)
		);
	}
}