<?php

function template_surlySettingsInitial() {
	global $txt, $boardurl, $forum_version;

	$surly_replace_urls = surlyGetOption('surly_replace_urls', array(0), true);
	$surly_trusted_groups = surlyGetOption('surly_trusted_groups', array(), true);
	$surly_trusted_domains = surlyGetOption('surly_trusted_domains', array(), true);

	echo '
	<div class="wrapper-surly" data-surly-initial="', surlyGetOption('surly_initial', '1-0'), '">
		<div class="ps-window">
			<div class="ps-top-title">
				<p>', $txt['surly_tab_plugin_settings'], '</p>
			</div>
			<div class="ps-window-content">
				<div class="ps-left-side">
					<div class="ps-left-content">
						<div class="ps-step-menu">
							<ul id="initial-steps" class="ps-menu">
								<li>
									<div class="ps-num-item"><span>1</span></div>
									<div class="ps-name-item"><p><span>', $txt['surly_title_registration'], '</span></p></div>
								</li>
								<li>
									<div class="ps-num-item"><span>2</span></div>
									<div class="ps-name-item"><p><span>', $txt['surly_title_domains'], '</span></p></div>
									<div class="ps-sub-menu">
										<ul>
											<li>
												<span class="sline"></span>
												<div class="ps-sub-name-item"><p><span>', $txt['surly_title_subdomain'], '</span></p></div>
											</li>
											<li>
												<span class="sline hlast"></span>
												<div class="ps-sub-name-item"><p><span>', $txt['surly_title_trusted_domains'], '</span></p></div>
											</li>
										</ul>
									</div>
								</li>
								<li>
									<div class="ps-num-item"><span>3</span></div>
									<div class="ps-name-item"><p><span>', $txt['surly_title_trusted_groups'], '</span></p></div>
								</li>
								<li>
									<div class="ps-num-item"><span>4</span></div>
									<div class="ps-name-item"><p><span>', $txt['surly_title_url_processing'], '</span></p></div>
									<div class="ps-sub-menu">
										<ul>
											<li>
												<span class="sline"></span>
												<div class="ps-sub-name-item"><p><span>', $txt['surly_title_shorten_urls'], '</span></p></div>
											</li>
											<li>
												<div class="ps-sub-name-item"><p><span>', $txt['surly_title_replace_urls'], '</span></p></div>
											</li>
										</ul>
									</div>
								</li>
							</ul>
						</div>
					</div>
				</div>
				<div class="ps-right-side">
					<div class="ps-right-content">
						<div id="surly-initial-step-1-0" style="display:none">';
							if (!surlyGetOption('surly_toolbar_id', false)) {
								echo '<iframe frameborder="0" scrolling="no" class="surly-auth" src="https://surdotly.com/settings/auth/?', http_build_query(array('url' => $boardurl, 'cmsId' => 8, 'meta' => array('cms_version' => $forum_version))), '"></iframe>';

							}
						echo '
						</div>
						<form id="surly-initial-step-2-1" style="display:none">
							<input type="hidden" name="action" value="surly_ajax_save_subdomain"/>
							<div class="ps-info-text">
								<p>', $txt['surly_description_subdomain'], '</p>
							</div>
							<div class="ps-cell">
								<div class="surly-field-error" data-field="surly-subdomain"></div>
							</div>
							<div class="ps-next-form">
								<div class="ps-left-row">
									<div class="ps-list">
										<ul>
											<li>
												<div class="ps-type-in">
													<input name="surly_subdomain" value="', surlyGetOption('surly_subdomain', ''), '" type="text" placeholder="', $txt['surly_placeholder_url'], '"/>
												</div>
											</li>
											<li>
												<div class="ps-type-buttons">
													<a id="surly-save-subdomain" href="#" class="ps-type-button ps-icon blue">', $txt['surly_button_next'], '<span> &rarr;</span></a>
												</div>
											</li>
										</ul>
									</div>
								</div>
							</div>
						</form>
						<div id="surly-initial-step-2-2" style="display:none">
							<div class="ps-info-text">
								<p>', $txt['surly_description_trusted_domains'], '</p>
							</div>
							<div class="ps-next-form">
								<div class="ps-list">
									<ul>
										<li>
											<form id="surly-trusted-domains">
												<div class="ps-adding">
													<div class="ps-inner-box">
														<div class="ps-table-box">
															<div class="ps-cell">
																<div class="w430">
																	<div class="ps-type-in">
																		<input id="surly-trusted-domain" name="surly_trusted_domain" value="" placeholder="', $txt['surly_placeholder_domain'], '"/>
																		<div class="ps-type-buttons">
																			<a id="surly-save-trusted-domain" href="#" class="ps-type-button blue">', $txt['surly_button_add_domain'], '</a>
																		</div>
																	</div>
																</div>
															</div>
															<div class="ps-cell">
																<div class="surly-field-error" data-field="surly-trusted-domain"></div>
															</div>
														</div>
														<div class="ps-central-box">
															<div class="ps-table-line">
																<ul>
																	<li class="first">
																		<span class="ps-type-check">
																			<input type="checkbox" id="surly_trusted_domains">
																		</span>
																		<label for="surly_trusted_domains">', $txt['surly_label_domain'], '</label>
																		<span class="num-item">', count($surly_trusted_domains) > 1 ? (count($surly_trusted_domains) . $txt['surly_label_items']) : (1 . $txt['surly_label_item']), '</span>
																	</li>';
																	foreach ($surly_trusted_domains as $key => $value) {
																		echo '
																		<li class="inner">
																			<span class="ps-type-check">
																				<input
																					id="surly_trusted_domains-', $key, '"
																					name="surly_trusted_domains[]"
																					value="', $value, '"
																					type="checkbox"/>
																			</span>
																			<label for="surly_trusted_domains-', $key, '">', $value, '</label>
																		</li>';
																	}
																	echo '
																	<li class="empty', !empty($surly_trusted_domains) ? ' hide' : '', '">
																		<label>', $txt['surly_label_no_items_found'], '</label>
																	</li>
																</ul>
																<div class="ps-type-buttons">
																	<a id="surly-delete-trusted-domains" href="#" class="ps-type-button ps-border lred pad30">', $txt['surly_button_delete'], '</a>
																</div>
															</div>
														</div>
													</div>
												</div>
											</form>
										</li>
										<li>
											<div class="ps-type-buttons">
												<a id="surly-save-trusted-domains" href="#" class="ps-type-button ps-icon blue">', $txt['surly_button_next'], '<span> &rarr;</span></a>
											</div>
										</li>
									</ul>
								</div>
							</div>
						</div>
						<form id="surly-initial-step-3-0" style="display:none">
							<input type="hidden" name="action" value="surly_ajax_save_trusted_groups"/>
							<div class="ps-info-text">
								<p', $txt['surly_description_trusted_groups'], '</p>
							</div>
							<div class="ps-next-form">
								<div class="ps-left-row">
									<div class="ps-list">
										<ul>
											<li>
												<div class="ps-list-in trusted-groups">
													<ul>';
													foreach(surlyGetGroups() as $id => $name) {
														echo '
														<li>
															<label for="surly_trusted_groups-', $id, '">', $name, '</label>
															<input
																id="surly_trusted_groups-', $id, '"
																name="surly_trusted_groups[]"
																value="', $id, '"
																type="checkbox"',
																in_array($id, $surly_trusted_groups) ? 'checked="checked"' : '', '/>
														</li>';
													}
													echo '
													</ul>
												</div>
											</li>
											<li>
												<div class="ps-type-buttons">
													<a id="surly-save-trusted-groups" href="#" class="ps-type-button ps-icon blue">', $txt['surly_button_next'], '<span> &rarr;</span></a>
												</div>
											</li>
										</ul>
									</div>
								</div>
							</div>
						</form>
						<form id="surly-initial-step-4-1" style="display:none">
							<input type="hidden" name="action" value="surly_ajax_save_shorten_urls"/>
							<div class="ps-info-text">
								<p>', sprintf($txt['surly_description_shorten_urls'], surlyGetOption('surly_toolbar_id', SURLY_DEFAULT_TOOLBAR_ID)), '</p>
							</div>
							<div class="ps-next-form">
								<div class="ps-left-row">
									<div class="ps-list">
										<ul>
											<li>
												<div class="ps-select-in">
													<select name="surly_shorten_urls">
														<option value="0"', !surlyGetOption('surly_shorten_urls', false) ? ' selected="selected"' : '', '>', $txt['surly_option_disable'], '</option>
														<option value="1"', surlyGetOption('surly_shorten_urls', false) ? ' selected="selected"' : '', '>', $txt['surly_option_enable'], '</option>
													</select>
												</div>
											</li>
											<li>
												<div class="ps-type-buttons">
													<a id="surly-save-shorten-urls" href="#" class="ps-type-button ps-icon blue">', $txt['surly_button_next'], '<span> &rarr;</span></a>
												</div>
											</li>
										</ul>
									</div>
								</div>
							</div>
						</form>
						<form id="surly-initial-step-4-2" style="display:none">
							<input type="hidden" name="action" value="surly_ajax_save_replace_urls"/>
							<div class="ps-info-text">
								<p>', $txt['surly_description_replace_urls'], '</p>
							</div>
							<div class="ps-next-form">
								<div class="ps-left-row">
									<div class="ps-list">
										<ul>
											<li>
												<div class="ps-list-in">
													<ul>
														<li>
															<label for="surly_replace_urls_nowhere">', $txt['surly_option_nowhere'], '</label>
															<input
																id="surly_replace_urls_nowhere"
																name="surly_replace_urls[]"
																value="0"
																type="checkbox"',
																in_array(0, $surly_replace_urls) ? 'checked="checked"' : '', '/>
														</li>
														<li>
															<label for="surly_replace_urls_posts">', $txt['surly_option_posts'], '</label>
															<input
																id="surly_replace_urls_posts"
																name="surly_replace_urls[]"
																value="1"
																type="checkbox"',
																in_array(1, $surly_replace_urls) ? 'checked="checked"' : '', '/>
														</li>
													</ul>
												</div>
											</li>
											<li>
												<div class="ps-type-buttons">
													<a id="surly-save-replace-urls" href="#" class="ps-type-button blue">', $txt['surly_button_finish'], '</a>
												</div>
											</li>
										</ul>
									</div>
								</div>
							</div>
						</form>
					</div>
				</div>
			</div>
		</div>
	</div>';
}

?>
