<?php

require_once $sourcedir . '/surly/lib/surly-sdk-php/surly/Surly.php';

define('SURLY_ACTION_TYPE_INSTALL', 1);
define('SURLY_ACTION_TYPE_AUTH', 2);
define('SURLY_ACTION_TYPE_ACTIVATION', 3);
define('SURLY_ACTION_TYPE_DEACTIVATION', 4);
define('SURLY_ACTION_TYPE_UNINSTALL', 5);
define('SURLY_ACTION_TYPE_SUBDOMAIN_LINK', 6);
define('SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK', 7);

class SmfSurly extends Surly
{
	var $isRootDomainAlive = null;
	
	/**
	 * This method accepts an associative array containing a key-value pairs
	 * of target URLs and their corresponding IDs to be stored in cache
	 * (either memcached or any RDBMS).
	 * @param array $url2shortIds
	 * @return void
	 */
	function cacheShortIds($url2shortIds)
	{
		global $smcFunc, $db_prefix;

		foreach ($url2shortIds as $url => $shortId) {
			$smcFunc['db_insert']('ignore', 
				'{db_prefix}surly_cache',
				array('hash' => 'string', 'short_id' => 'string', 'long_url' => 'string'),
				array($this->hashLongUrl($url), $shortId, $url),
				array('hash', 'long_url')
			);
		}
	}

	/**
	 * This method accepts a collection of target URLs
	 * (without "http://www" prefix)
	 * and returns an associative array containing a key-value pairs
	 * of target URLs and their corresponding IDs found in cache.
	 *
	 * @param array $urls
	 * @return array
	 */
	function getCachedShortIds($urls)
	{
		global $smcFunc, $db_prefix;
		$url2shortIds = array();

		foreach ($urls as $url) {
	
			$sql = "SELECT short_id 
					FROM `{$db_prefix}surly_cache` 
					WHERE `long_url` = '$url'";
			$query   = $smcFunc['db_query']('', $sql);
			$shortId = $smcFunc['db_fetch_row']($query);
			$shortId = $shortId[0];
			
			if (!empty($shortId)) {
				$url2shortIds[$url] = $shortId;
			}
		}
		return $url2shortIds;
	}
	/**
	 * This method returns cached root status
	 * 
	 * @return array|bool|string
	 */
	function getCachedRootStatus()
	{
		return cache_get_data('surly_rootstatus', 86400);
	}

	/**
	 * This method accepts a root status string
	 * 
	 * @param string $rootStatus
	 */
	function cacheRootStatus($rootStatus)
	{
		cache_put_data('surly_rootstatus', $rootStatus, $ttl = 86400);
	}
	
	
	function hashLongUrl($longUrl)
	{
		$hash = md5($longUrl);
		
		// Manually translate to binary form to support PHP 4.3
		$result = '';
		for ($i = 0; $i < 32; $i+=2) {
		  $digits = substr($hash, $i, 2);
		  $number = hexdec($digits);
		  $result.=chr($number);
		}
		return $result;
	}

	function process_url($url)
	{
		$href = "<a href='$url'></a>";
		$processed = $this->process($href);
		$replace_from = array("<a href='", "'>", "</a>");
		$replace_to = array('','','');

		return str_replace($replace_from, $replace_to, $processed);
	}

	function trackHistory($actionType)
	{
		global $boardurl;

		$this->timeout = SURLY_API_TRACK_TIMEOUT;

		$this->_performRequest(
			$this->apiHost . SURLY_API_TRACK_HISTORY_PATH,  'POST',
				array(
					'action_type' => $actionType,
					'site_url' => $boardurl,
					'toolbar_id' => surlyGetOption('surly_toolbar_id', ''),
					'hash' => surlyGetOption('surly_activation_hash', ''),
				)
		);

		$this->timeout = SURLY_API_TIMEOUT;
	}

	function linkSubdomain($subdomain)
	{
		return $this->_performRequest(
			$this->apiHost . SURLY_API_SUBDOMAIN_LINK, 'POST',
				array(
					'toolbar_id' => surlyGetOption('surly_toolbar_id'),
					'password' => surlyGetOption('surly_toolbar_password'),
					'subdomain' => $subdomain,
				)
		);
	}
}
?>
