<?php

require_once $sourcedir . '/Subs-Membergroups.php';
require_once $sourcedir . '/surly/SurlySmf.php';

define('SURLY_TAB_SETTINGS_PLUGIN', 'settings-plugin');
define('SURLY_TAB_SETTINGS_TOOLBAR', 'settings-toolbar');

function surlyView() {
	global $txt, $context;

	isAllowedTo('admin_forum');
	loadLanguage('Surly');

	surlyAddCss();
	surlyAddJs();

	$context['page_title'] =  $txt['surly_tab_plugin_settings'];

	if (surlyGetOption('surly_initial', false)) {
		loadTemplate('SurlySettingsInitial');
		$context['sub_template'] = 'surlySettingsInitial';
	}
	else if (surlyGetOption('surly_toolbar_id', false)) {
		if (isset($_REQUEST['sa']) && $_REQUEST['sa'] == SURLY_TAB_SETTINGS_TOOLBAR) {
			loadTemplate('SurlySettingsToolbar');
			$context['page_title'] =  $txt['surly_tab_toolbar_settings'];
			$context['sub_template'] = 'surlySettingsToolbar';
		}
		else {
			loadTemplate('SurlySettingsPlugin');
			$context['sub_template'] = 'surlySettingsPlugin';
		}
	} else
	{
		loadTemplate('SurlySettingsShort');
		$context['sub_template'] = 'surlySettingsShort';
	}
}

function surlyAddCss() {
	global $context, $settings;

	$context['html_headers'] .= '<link type="text/css" rel="stylesheet" href="https://fonts.googleapis.com/css?family=Noto+Sans:400,400i,700,700i"/>';
	$context['html_headers'] .= '<link type="text/css" rel="stylesheet" href="' . $settings['default_theme_url'] . '/surly/css/font-awesome.min.css"/>';
	$context['html_headers'] .= '<link type="text/css" rel="stylesheet" href="' . $settings['default_theme_url'] . '/surly/css/surly-style.css"/>';
	$context['html_headers'] .= '<link type="text/css" rel="stylesheet" href="' . $settings['default_theme_url'] . '/surly/css/chosen.css"/>';
}

function surlyAddJs() {
	global $context, $settings;

	$context['html_headers'] .= '<script type="text/javascript" src="' . $settings['default_theme_url'] . '/surly/js/jquery-1.8.2.min.js' . '"></script>';
	$context['html_headers'] .= '<script type="text/javascript" src="' . $settings['default_theme_url'] . '/surly/js/chosen.jquery.min.js' . '"></script>';
	$context['html_headers'] .= '<script type="text/javascript" src="' . $settings['default_theme_url'] . '/surly/js/jquery.icheck.min.js' . '"></script>';
	$context['html_headers'] .= '<script type="text/javascript" src="' . $settings['default_theme_url'] . '/surly/js/jquery.postMessage.min.js' . '"></script>';
	$context['html_headers'] .= '<script type="text/javascript" src="' . $settings['default_theme_url'] . '/surly/js/surly-script.js' . '"></script>';
}

function surlyGetOption($option, $default = false, $unserialize = false) {
	global $modSettings;

	if (!empty($modSettings[$option])) {
		return $unserialize ? unserialize($modSettings[$option]) : $modSettings[$option];
	} else {
		return $default;
	}
}

function surlyGetGroups() {
	global $sourcedir;

	$list_membergroups = list_getMembergroups(0,0,'CASE WHEN id_group < 4 THEN id_group ELSE 4 END, group_name', 'regular');

	$member_groups = array();

	foreach ($list_membergroups as $member_group) {
		$member_groups[$member_group['id_group']] = $member_group['group_name'];
	}

	return $member_groups;
}

function surlyIsTrustedUser($userId) {
	global $user_profile;

	if ($userId) {
		loadMemberData($userId, false, 'profile');

		$surly_trusted_groups = surlyGetOption('surly_trusted_groups', array(), true);

		if (in_array($user_profile[$userId]['id_group'], $surly_trusted_groups)) {
			return true;
		}
	}

	return false;
}

function surlyGetSdk() {
	global $boardurl;

	static $surly;

	if (!isset($surly)) {
		$surly = new SmfSurly(
			surlyGetOption('surly_toolbar_id', SURLY_DEFAULT_TOOLBAR_ID),
			(bool) surlyGetOption('surly_shorten_urls')
		);

		$surly_subdomain = surlyGetOption('surly_subdomain', '');

		if ($surly_subdomain) {
			$surly->setPanelHost($surly_subdomain);
		}

		foreach (surlyGetOption('surly_trusted_domains', array(), true) as $domain) {
			$surly->whitelist($domain);
		}

		$site_url = parse_url($boardurl, PHP_URL_HOST);
		$surly->whitelist($site_url['host']);
	}

	return $surly;
}

function surlyAjaxSaveSettings() {
	surlySaveReplaceUrls();
	surlySaveShortenUrls();
	surlySaveTrustedGroups();

	$result = surlySaveSubdomain();

	if (isset($result['error'])) {
		return array('error' => array('subdomain' => $result['error']));
	}

	return array('success' => true);
}

function surlyAjaxSaveToolbarSettings() {
	$surly_toolbar_id = isset($_POST['surly_toolbar_id']) ? $_POST['surly_toolbar_id'] : '';
	$surly_toolbar_password = isset($_POST['surly_toolbar_password']) ? $_POST['surly_toolbar_password'] : '';

	updateSettings(array(
		'surly_toolbar_id' => $surly_toolbar_id,
		'surly_toolbar_password' => $surly_toolbar_password,
		'surly_initial' => '2-1',
	));

	$surly = surlyGetSdk();
	$surly->trackHistory(SURLY_ACTION_TYPE_AUTH);

	return array('success' => true);
}

function surlyAjaxSaveSubdomain() {
	$result = surlySaveSubdomain();

	if (isset($result['error'])) {
		return array('error' => array('subdomain' => $result['error']));
	} else {
		updateSettings(array('surly_initial' => '2-2'));

		return array('success' => true);
	}
}

function surlyAjaxSaveTrustedDomain() {
	global $txt;

	loadLanguage('Surly');

	$trusted_domain = isset($_POST['surly_trusted_domain'])? preg_replace('/^https?:\/\/(.+)/',"$1", strtolower(trim($_POST['surly_trusted_domain']))) : '';

	if (empty($trusted_domain)) {
		return array('error' => $txt['surly_error_domain_name']);
	}

	if (preg_match('!(?P<host>(?:[a-z0-9_-]+\.)+[a-z]+)!u', $trusted_domain, $result)) {
		$trusted_domain = $result['host'];
	} else {
		return array('error' => $txt['surly_error_domain_name']);
	}

	$surly_trusted_domains = surlyGetOption('surly_trusted_domains', array(), true);

	if (in_array($trusted_domain, $surly_trusted_domains)) {
		return array('error' => $txt['surly_error_domain_exist']);
	}

	updateSettings(array(
		'surly_trusted_domains' => serialize(array_merge($surly_trusted_domains, array($trusted_domain))),
	));

	return array('domain' => $trusted_domain);
}

function surlyAjaxDeleteTrustedDomains() {
	$trusted_domains = isset($_POST['surly_trusted_domains']) ? (array) $_POST['surly_trusted_domains'] : array();

	$surly_trusted_domains = surlyGetOption('surly_trusted_domains', array(), true);

	updateSettings(array(
		'surly_trusted_domains' => serialize(array_diff($surly_trusted_domains, $trusted_domains)),
	));

	return array('success' => true);
}

function surlyAjaxSaveTrustedGroups() {
	surlySaveTrustedGroups();

	updateSettings(array('surly_initial' => '4-1'));

	return array('success' => true);
}

function surlyAjaxSaveShortenUrls() {
	surlySaveShortenUrls();

	updateSettings(array('surly_initial' => '4-2'));

	return array('success' => true);
}

function surlyAjaxSaveReplaceUrls() {
	surlySaveReplaceUrls();

	$surly = surlyGetSdk();
	$surly->trackHistory(SURLY_ACTION_TYPE_ACTIVATION);

	updateSettings(array('surly_initial' => '0'));

	return array('success' => true);
}

function surlyAjaxSkipStep() {
	$steps = array('1-0', '2-1', '2-2', '3-0', '4-1', '4-2');

	$next_step = isset($_POST['next_step']) && in_array($_POST['next_step'], $steps) ? $_POST['next_step'] : $steps[0];

	updateSettings(array('surly_initial' => $next_step));
}

function surlySaveSubdomain() {
	global $txt;

	loadLanguage('Surly');

	$surly_subdomain = isset($_POST['surly_subdomain']) ? trim($_POST['surly_subdomain']) : '';

	if ($surly_subdomain != surlyGetOption('surly_subdomain', '')) {
		$surly = surlyGetSdk();

		if ($surly_subdomain == '') {
			$surly->trackHistory(SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK);
		} else {
			$result = json_decode($surly->linkSubdomain($surly_subdomain), true);

			if (isset($result['error_code'])) {
				$errors = array(
					1 => $txt['surly_error_subdomain_require'],
					2 => $txt['surly_error_subdomain_invalid'],
					3 => $txt['surly_error_subdomain_exist'],
					4 => $txt['surly_error_subdomain_cname'],
					5 => $txt['surly_error_unexpected'],
				);

				return isset($errors[$result['error_code']])
					? array('error' => $errors[$result['error_code']]) : array('error' => $errors[5]);
			}
			elseif (isset($result['subdomain'])) {
				$surly_subdomain = $result['subdomain'];

				$surly->trackHistory(SURLY_ACTION_TYPE_SUBDOMAIN_LINK);
			}
			else {
				$surly_subdomain = surlyGetOption('surly_subdomain', '');
			}
		}
	}

	updateSettings(array('surly_subdomain' => $surly_subdomain));
}

function surlySaveTrustedGroups() {
	$surly_trusted_groups = isset($_POST['surly_trusted_groups']) ? (array) $_POST['surly_trusted_groups'] : array();

	$groups = surlyGetGroups();

	foreach ($surly_trusted_groups as $key => $value) {
		if (!isset($groups[$value])) {
			unset($surly_trusted_groups[$key]);
		}
	}

	updateSettings(array('surly_trusted_groups' => serialize($surly_trusted_groups)));
}

function surlySaveShortenUrls() {
	$surly_shorten_urls = !empty($_POST['surly_shorten_urls']);

	updateSettings(array('surly_shorten_urls' => (int) $surly_shorten_urls));
}

function surlySaveReplaceUrls() {
	$surly_replace_urls = isset($_POST['surly_replace_urls']) ? (array) $_POST['surly_replace_urls'] : array(0);
	$surly_replace_urls = array_intersect(array(0), $surly_replace_urls) ?: array_intersect(array(1), $surly_replace_urls) ?: array(0);

	updateSettings(array('surly_replace_urls' => serialize($surly_replace_urls)));
}

?>
