<?php
/*
 * Copyright (c) 2012-2017 Sur.ly
 * This file is part of Sur.ly PunBB plugin.
 * 
 * Sur.ly PunBB plugin plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Sur.ly PunBB plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Sur.ly PunBB plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

if (!defined('FORUM')) die();

define('SURLY_TAB_SETTINGS_PLUGIN', 'settings-plugin');
define('SURLY_TAB_SETTINGS_TOOLBAR', 'settings-toolbar');

require_once $ext_info['path'] . '/include/SurlyPunBB.php';

function surly_get_sdk() {
	global $base_url;

	static $surly;

	if (!isset($surly)) {
		$surly = new SurlyPunBB(
			surly_get_option('surly_toolbar_id', SURLY_DEFAULT_TOOLBAR_ID),
			(bool) surly_get_option('surly_shorten_urls')
		);

		if (surly_get_option('surly_subdomain')) {
			$surly->setPanelHost(surly_get_option('surly_subdomain'));
		}

		foreach (surly_get_option('surly_trusted_domains', array(), true) as $domain) {
			$surly->whitelist($domain);
		}

		$site_url = parse_url($base_url);
		$surly->whitelist($site_url['host']);
	}

	return $surly;
}

function surly_replace($content, $groupId)
{
	if (in_array(1, surly_get_option('surly_replace_urls', array(0), true))) {

		$surly = surly_get_sdk();

		return in_array($groupId, surly_get_option('surly_trusted_groups', array(), true))
			? $content : $surly->process($content);
	}

	return $content;
}

function surly_get_groups() {
	global $forum_db;

	$result = $forum_db->query_build(array(
		'SELECT' => 'g_id, g_title',
		'FROM' => 'groups',
		'ORDER BY' => 'g_title',
	)) or error(__FILE__, __LINE__);

	$groups = array();

	while ($group = $forum_db->fetch_assoc($result)) {
		$groups[$group['g_id']] = $group['g_title'];
	}

	return $groups;
}

function surly_set_option($option, $value, $serialize = false) {
	global $forum_db;

	$option = 'o_' . $option;
	$value = $serialize ? serialize($value) : $value;

	$result = $forum_db->query_build(array(
		'SELECT' => 'conf_value',
		'FROM' => 'config',
		'WHERE' => 'conf_name="' . $forum_db->escape($option) . '"',

	)) or error(__FILE__, __LINE__);

	if ($forum_db->fetch_row($result)) {
		$forum_db->query_build(array(
			'UPDATE' => 'config',
			'SET' => 'conf_value="' .  $forum_db->escape($value) . '"',
			'WHERE' => 'conf_name="' . $forum_db->escape($option) . '"',
		)) or error(__FILE__, __LINE__);
	} else {
		$forum_db->query_build(array(
			'INSERT' => 'conf_name, conf_value',
			'INTO' => 'config',
			'VALUES' => '"' .  $forum_db->escape($option) . '", "' . $forum_db->escape($value) . '"',
		)) or error(__FILE__, __LINE__);
	}
}

function surly_get_option($option, $default = false, $unserialize = false) {
	global $forum_config;

	$option = 'o_' . $option;

	if (isset($forum_config[$option])) {
		return $unserialize ? unserialize($forum_config[$option]) : $forum_config[$option];
	} else {
		return $default;
	}
}

function surly_get_user_group($userId = null) {
	global $forum_db;

	if (!$userId) {
		return false;
	}

	$result = $forum_db->query_build(array(
		'SELECT' => 'group_id',
		'FROM' => 'users',
		'WHERE' => 'id=' . $userId,
	)) or error(__FILE__, __LINE__);

	if ($group = $forum_db->fetch_assoc($result)) {
		return $group['group_id'];
	} else {
		return false;
	}
}