<?php
/*
 * Copyright (c) 2012-2017 Sur.ly
 * This file is part of Sur.ly PunBB plugin.
 * 
 * Sur.ly PunBB plugin plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * Sur.ly PunBB plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Sur.ly PunBB plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

require_once $ext_info['path'] . '/lib/surly-sdk-php/surly/Surly.php';

define('SURLY_ACTION_TYPE_INSTALL', 1);
define('SURLY_ACTION_TYPE_AUTH', 2);
define('SURLY_ACTION_TYPE_ACTIVATION', 3);
define('SURLY_ACTION_TYPE_DEACTIVATION', 4);
define('SURLY_ACTION_TYPE_UNINSTALL', 5);
define('SURLY_ACTION_TYPE_SUBDOMAIN_LINK', 6);
define('SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK', 7);

class SurlyPunBB extends Surly
{
	var $rootStatusKey = 'surly_root_status';
	var $isRootDomainAlive = null;

	function hashLongUrl($longUrl)
	{
		$hash = md5($longUrl);

		// Manually translate to binary form to support PHP 4.3
		$result = '';
		for ($i = 0; $i < 32; $i+=2) {
			$digits = substr($hash, $i, 2);
			$number = hexdec($digits);
			$result.=chr($number);
		}

		return $result;
	}

	function cacheShortIds($url2shortIds)
	{
		global $forum_db, $db_prefix;

		if (empty($url2shortIds)) {
			return;
		}

		$insert = array();

		foreach ($url2shortIds as $longUrl => $shortId) {
			$hash = $this->hashLongUrl($longUrl);

			$insert[] =  "('" . $forum_db->escape($longUrl) . "','" . $forum_db->escape($hash) . "','" . $forum_db->escape($shortId) . "')";
		}

		$forum_db->query("INSERT IGNORE INTO `" . $db_prefix . "shortener_cache" . "` (`long_url`,`hash`,`short_id`) VALUES " . implode(",", $insert))
			or error(__FILE__, __LINE__);
	}

	function getCachedShortIds($urls)
	{
		global $forum_db, $db_prefix;

		if (empty($urls)) {
			return array();
		}

		$where = array();
		$result = array();

		foreach ($urls as $longUrl) {
			$hash = $this->hashLongUrl($longUrl);
			$where[] = "(`hash` = '" . $forum_db->escape($hash) . "' AND `long_url` = '" . $forum_db->escape($longUrl) . "')";
		}

		$res = $forum_db->query("SELECT `short_id`, `long_url` FROM  `" . $db_prefix . "shortener_cache" . "` WHERE " . implode(" OR ", $where))
			or error(__FILE__, __LINE__);

		while ($r = $forum_db->fetch_assoc($res)) {
			$result[$r['long_url']] = $r['short_id'];
		}

		return $result;
	}

	function getCachedRootStatus()
	{
		global $forum_db, $db_prefix;

		$query = 'SELECT conf_value FROM `'. $db_prefix . 'config` WHERE conf_name = "' . $this->rootStatusKey . '"';

		$res = $forum_db->query($query) or error(__FILE__, __LINE__);

		if ($result = $forum_db->fetch_assoc($res)) {
			return $result['conf_value'];
		}

		return false;
	}

	function cacheRootStatus($rootStatus)
	{
		global $forum_db, $db_prefix;

		$rootStatus = $forum_db->escape($rootStatus);

		$query = '
			INSERT INTO ' . $db_prefix .'config (conf_name, conf_value)
			VALUES ("' . $this->rootStatusKey . '", "' . $rootStatus . '")
			ON DUPLICATE KEY UPDATE conf_value="' . $rootStatus . '"';

		$forum_db->query($query) or error(__FILE__, __LINE__);
	}

	function trackHistory($actionType)
	{
		global $base_url;

		$this->timeout = SURLY_API_TRACK_TIMEOUT;

		$this->_performRequest(
			$this->apiHost . SURLY_API_TRACK_HISTORY_PATH,  'POST',
				array(
					'action_type' => $actionType,
					'site_url' => $base_url,
					'toolbar_id' => surly_get_option('surly_toolbar_id', null),
					'hash' => surly_get_option('surly_activation_hash'),
				)
		);

		$this->timeout = SURLY_API_TIMEOUT;
	}

	function linkSubdomain($subdomain)
	{
		return $this->_performRequest(
			$this->apiHost . SURLY_API_SUBDOMAIN_LINK, 'POST',
				array(
					'toolbar_id' => surly_get_option('surly_toolbar_id'),
					'password' => surly_get_option('surly_toolbar_password'),
					'subdomain' => $subdomain,
				)
		);
	}
}