<?php
/**
*
* @package Sur.ly
* @copyright (c) 2014 Sur.ly <http://sur.ly>
* @license GNU General Public License, version 2 (GPL-2.0)
*
*/

namespace surly\surly\operators;

if (!defined('IN_PHPBB'))
{
	exit;
}

// for submodule
if (!class_exists('Surly'))
{
	require_once implode(DIRECTORY_SEPARATOR, array(__DIR__, '..', 'vendor', 'surly-sdk-php', 'surly', 'Surly.php'));
}

use Surly;

class surly_phpbb extends \Surly
{
	const SURLY_ACTION_TYPE_INSTALL = 1;
	const SURLY_ACTION_TYPE_AUTH = 2;
	const SURLY_ACTION_TYPE_ACTIVATION = 3;
	const SURLY_ACTION_TYPE_DEACTIVATION = 4;
	const SURLY_ACTION_TYPE_UNINSTALL = 5;
	const SURLY_ACTION_TYPE_SUBDOMAIN_LINK = 6;
	const SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK = 7;

	const CMS_PHPBB = 5;

	public $isRootDomainAlive = null;

	protected $rootStatusKey = 'surly_root_status';

	protected $surly_cache_table;

	protected $db;

	protected $config;


	public function __construct(\phpbb\db\driver\driver_interface $db, \phpbb\config\config $config, $surly_cache_table = '')
	{
		$this->db = $db;
		$this->surly_cache_table = $surly_cache_table;
		$this->config = $config;

		parent::__construct($this->config->offsetGet('surly_toolbar_id'), (bool) $this->config->offsetGet('surly_shorten_urls'));

		if ($surly_subdomain = $this->config->offsetGet('surly_subdomain'))
		{
			$this->setPanelHost($surly_subdomain);
		}

		$surly_trusted_domains = $this->config->offsetGet('surly_ignore_domains')
			? json_decode($this->config['surly_ignore_domains'], true) : array();

		foreach ($surly_trusted_domains as $domain)
		{
			$this->whitelist($domain);
		}

		$site_url = parse_url(generate_board_url(true), PHP_URL_HOST);
		$this->whitelist($site_url);
	}

	public function is_user_ignored($user_id)
	{
		$surly_trusted_groups = $this->config->offsetGet('surly_trusted_groups')
			? json_decode($this->config['surly_trusted_groups'], true) : array();

		$sql = 'SELECT u.group_id
			FROM ' . USERS_TABLE . ' u
			WHERE u.user_id = ' . (int) $user_id;

		$result = $this->db->sql_query($sql);
		$usergroups[] = $this->db->sql_fetchfield('group_id');
		$this->db->sql_freeresult($result);

		return (bool) array_intersect($usergroups, $surly_trusted_groups);
	}

	public function cacheShortIds($url2shortIds)
	{
		foreach ($url2shortIds as $url => $id)
		{
			if (strlen($url) <= 255)
			{
				$values = array(
					'long_url' => $url,
					'hash' => $this->_md5($url),
					'short_id' => $id,
				);

				$this->db->sql_query('INSERT IGNORE INTO ' . $this->surly_cache_table . ' ' . $this->db->sql_build_array('INSERT', $values));
			}
		}

		parent::cacheShortIds($url2shortIds);
	}

	public function getCachedShortIds($urls)
	{
		$result = parent::getCachedShortIds($urls);

		if (!empty($urls))
		{
			$where = array();
			foreach ($urls as $url)
			{
				if (!empty($url))
				{
					$val = array(
						'long_url' => $url,
						'hash' => $this->_md5($url),
					);
					$where[] = '(' . $this->db->sql_build_array('SELECT', $val) . ')';
				}
			}

			if (!empty($where))
			{
				$where_sql = implode(' OR ', $where);
				$sql = 'SELECT *
					FROM ' . $this->surly_cache_table . '
					WHERE ' . $where_sql;

				$sql_result = $this->db->sql_query($sql);
				while ($row = $this->db->sql_fetchrow($sql_result))
				{
					$result[$row['long_url']] = $row['short_id'];
				}
				$this->db->sql_freeresult($sql_result);
			}
		}

		return $result;
	}

	protected function _md5($url)
	{
		$hash = md5($url);
		$result = '';
		for ($i = 0; $i < 32; $i+=2)
		{
			$digits = substr($hash, $i, 2);
			$number = hexdec($digits);
			$result.=chr($number);
		}

		return $result;
	}

	public function cacheRootStatus($rootStatus)
	{
		$this->config->set($this->rootStatusKey, $rootStatus);
	}

	public function getCachedRootStatus()
	{
		return $this->config[$this->rootStatusKey] ? $this->config[$this->rootStatusKey] : false;
	}

	public function getSurlyApiUseragent()
	{
		return 'surly_api_caller (running ' . str_replace(array('http://', 'https://'), array(''), generate_board_url()) . ')';
	}

	public function linkSubdomain($subdomain)
	{
		return $this->_performRequest(
			$this->apiHost . SURLY_API_SUBDOMAIN_LINK, 'POST',
				array('toolbar_id' => $this->config->offsetGet('surly_toolbar_id'),
				'password' => $this->config->offsetGet('surly_toolbar_password'),
				'subdomain' => $subdomain,
			)
		);
	}

	public function trackHistory($actionType)
	{
		$this->timeout = SURLY_API_TRACK_TIMEOUT;

		$this->_performRequest(
			$this->apiHost . SURLY_API_TRACK_HISTORY_PATH,  'POST',
				array(
					'action_type' => $actionType,
					'site_url' => generate_board_url(true),
                    'toolbar_id' => $this->config->offsetGet('surly_toolbar_id'),
                    'hash' => $this->config->offsetGet('surly_activation_hash'),
				)
		);

		$this->timeout = SURLY_API_TIMEOUT;
	}
}
