<?php
/**
*
* @package Sur.ly
* @copyright (c) 2014 Sur.ly <http://sur.ly>
* @license GNU General Public License, version 2 (GPL-2.0)
*
*/

namespace surly\surly\controller;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
* Admin controller
*/
class admin_controller
{
	/** @var \phpbb\config\config */
	protected $config;

	/** @var \phpbb\db\driver\driver_interface */
	protected $db;

	/** @var \phpbb\request\request */
	protected $request;

	/** @var \phpbb\template\template */
	protected $template;

	/** @var \phpbb\user */
	protected $user;

	/** @var ContainerInterface */
	protected $container;

	/** @var string phpBB root path */
	protected $root_path;

	/** @var string phpEx */
	protected $php_ext;

	/** @var string Custom form action */
	protected $u_action;

	/** @var \surly\surly\operators\surly_phpbb */
	protected $surly;

	const SURLY_PANEL_URL = 'https://surdotly.com/settings/';

	const SURLY_REPLACE_URLS_NOWHERE = 0;
	const SURLY_REPLACE_URLS_POSTS = 1;

	/**
	* Constructor
	*
	* @param \phpbb\config\config $config Config object
	* @param \phpbb\db\driver\driver_interface $db Database object
	* @param \phpbb\request\request $request Request object
	* @param \phpbb\template\template $template Template object
	* @param \phpbb\user $user User object
	* @param ContainerInterface $container Service container interface
	* @param string $root_path phpBB root path
	* @param string $php_ext phpEx
	* @param \surly\surly\operators\surly_phpbb $surly Surly
	* @return \surly\surly\controller\admin_controller
	* @access public
	*/
	public function __construct(
		\phpbb\config\config $config,
		\phpbb\db\driver\driver_interface $db,
		\phpbb\request\request $request,
		\phpbb\template\template $template,
		\phpbb\user $user,
		ContainerInterface $container,
		$root_path,
		$php_ext,
		\surly\surly\operators\surly_phpbb $surly
		)
	{
		$this->config = $config;
		$this->db = $db;
		$this->request = $request;
		$this->template = $template;
		$this->user = $user;
		$this->container = $container;
		$this->root_path = $root_path;
		$this->php_ext = $php_ext;
		$this->surly = $surly;
	}

	public function display_settings_short()
	{
		$surly_replace_urls = $this->config->offsetGet('surly_replace_urls') ?
			json_decode($this->config['surly_replace_urls'], true) : array(self::SURLY_REPLACE_URLS_NOWHERE);

		$this->template->assign_vars(array(
			'SURLY_REPLACE_URLS' => array(
				'NOWHERE' => in_array(self::SURLY_REPLACE_URLS_NOWHERE, $surly_replace_urls),
				'POSTS' => in_array(self::SURLY_REPLACE_URLS_POSTS, $surly_replace_urls),
			),
		));
	}

	public function display_settings_initial()
	{
		$surly_replace_urls = $this->config->offsetGet('surly_replace_urls') ?
			json_decode($this->config['surly_replace_urls'], true) : array(self::SURLY_REPLACE_URLS_NOWHERE);

		$surly_toolbar_id = $this->config->offsetGet('surly_toolbar_id')
			? $this->config['surly_toolbar_id'] : SURLY_DEFAULT_TOOLBAR_ID;

		$surly_trusted_groups = $this->config->offsetGet('surly_trusted_groups')
			? json_decode($this->config['surly_trusted_groups'], true) : array();

		$surly_trusted_domains = $this->config->offsetGet('surly_ignore_domains')
			? json_decode($this->config['surly_ignore_domains'], true) : array();

		foreach ($surly_trusted_domains as $key => $value)
		{
			$this->template->assign_block_vars('SURLY_TRUSTED_DOMAINS', array(
				'ID' => $key,
				'DOMAIN_NAME' => $value,
			));
		}

		$groups_sql = 'SELECT DISTINCT g.group_type, g.group_name, g.group_id
			FROM ' . GROUPS_TABLE . ' g
			ORDER BY g.group_type DESC, g.group_name ASC';

		$groups = $this->db->sql_query($groups_sql);

		while ($row = $this->db->sql_fetchrow($groups))
		{
			$this->template->assign_block_vars('SURLY_TRUSTED_GROUPS', array(
				'ID' => $row['group_id'],
				'NAME' => ($row['group_type'] == GROUP_SPECIAL) ? $this->user->lang('G_' . $row['group_name']) : $row['group_name'],
				'SELECTED' => in_array($row['group_id'], $surly_trusted_groups),
			));
		}

		$surly_auth_url = self::SURLY_PANEL_URL . 'auth/?' . http_build_query(array(
			'url' => generate_board_url(true),
			'cmsId' => \surly\surly\operators\surly_phpbb::CMS_PHPBB,
			'meta' => array('cms_version' => PHPBB_VERSION),
		));

		$this->template->assign_vars(array(
			'L_ACP_SURLY_DESCRIPTION_SHORTEN_URLS' => sprintf($this->user->lang('ACP_SURLY_DESCRIPTION_SHORTEN_URLS'), $surly_toolbar_id),
			'U_SURLY_AUTH_URL' => $surly_auth_url,
			'SURLY_REPLACE_URLS' => array(
				'NOWHERE' => in_array(self::SURLY_REPLACE_URLS_NOWHERE, $surly_replace_urls),
				'POSTS' => in_array(self::SURLY_REPLACE_URLS_POSTS, $surly_replace_urls),
			),
			'SURLY_TOOLBAR_PASSWORD' => $this->config->offsetGet('surly_toolbar_password'),
			'SURLY_SHORTEN_URLS' => (bool) $this->config->offsetGet('surly_shorten_urls'),
			'SURLY_SUBDOMAIN' => $this->config->offsetGet('surly_subdomain'),
			'SURLY_INITIAL' => $this->config->offsetGet('surly_initial') ? $this->config->offsetGet('surly_initial') : '1-0',
			'SURLY_TRUSTED_DOMAINS_LENGTH' => count($surly_trusted_domains),
		));
	}

	public function display_settings_plugin()
	{
		$surly_replace_urls = $this->config->offsetGet('surly_replace_urls')
			? json_decode($this->config['surly_replace_urls'], true) : array(self::SURLY_REPLACE_URLS_NOWHERE);

		$surly_toolbar_id = $this->config->offsetGet('surly_toolbar_id')
			? $this->config['surly_toolbar_id'] : SURLY_DEFAULT_TOOLBAR_ID;

		$surly_trusted_groups = $this->config->offsetGet('surly_trusted_groups')
			? json_decode($this->config['surly_trusted_groups'], true) : array();

		$surly_trusted_domains = $this->config->offsetGet('surly_ignore_domains')
			? json_decode($this->config['surly_ignore_domains'], true) : array();

		foreach ($surly_trusted_domains as $key => $value)
		{
			$this->template->assign_block_vars('SURLY_TRUSTED_DOMAINS', array(
				'ID' => $key,
				'DOMAIN_NAME' => $value,
			));
		}

		$groups_sql = 'SELECT DISTINCT g.group_type, g.group_name, g.group_id
			FROM ' . GROUPS_TABLE . ' g
			ORDER BY g.group_type DESC, g.group_name ASC';

		$groups = $this->db->sql_query($groups_sql);

		while ($row = $this->db->sql_fetchrow($groups))
		{
			$this->template->assign_block_vars('SURLY_TRUSTED_GROUPS', array(
				'ID' => $row['group_id'],
				'NAME' => ($row['group_type'] == GROUP_SPECIAL) ? $this->user->lang('G_' . $row['group_name']) : $row['group_name'],
				'SELECTED' => in_array($row['group_id'], $surly_trusted_groups),
			));
		}

		$this->template->assign_vars(array(
			'L_ACP_SURLY_DESCRIPTION_SHORTEN_URLS' => sprintf($this->user->lang('ACP_SURLY_DESCRIPTION_SHORTEN_URLS'), $surly_toolbar_id),
			'SURLY_REPLACE_URLS' => array(
				'NOWHERE' => in_array(self::SURLY_REPLACE_URLS_NOWHERE, $surly_replace_urls),
				'POSTS' => in_array(self::SURLY_REPLACE_URLS_POSTS, $surly_replace_urls),
			),
			'SURLY_SHORTEN_URLS' => (bool) $this->config->offsetGet('surly_shorten_urls'),
			'SURLY_SUBDOMAIN' => $this->config->offsetGet('surly_subdomain'),
			'SURLY_TRUSTED_DOMAINS_LENGTH' => count($surly_trusted_domains),
		));
	}

	public function display_settings_toolbar()
	{
		$surly_panel_url = self::SURLY_PANEL_URL . $this->config->offsetGet('surly_toolbar_id')
			. '/plugin_access?password=' . $this->config->offsetGet('surly_toolbar_password');

		$this->template->assign_vars(array(
			'U_SURLY_PANAE_URL' => $surly_panel_url,
		));
	}

	public function ajax_save_toolbar_settings()
	{
		$this->config->set('surly_toolbar_id', $this->request->variable('surly_toolbar_id', ''));
		$this->config->set('surly_toolbar_password', $this->request->variable('surly_toolbar_password', ''));
		$this->config->set('surly_initial', '2-1');

		$this->surly->trackHistory(\surly\surly\operators\surly_phpbb::SURLY_ACTION_TYPE_AUTH);

		$json_response = new \phpbb\json_response;
		$json_response->send(array('success' => true));
	}

	public function ajax_save_subdomain()
	{
		$json_response = new \phpbb\json_response;

		$result = $this->save_subdomain();

		if (isset($result['error'])) {
			$json_response->send(array('error' => array('subdomain' => $result['error'])));
		} else {
			$this->config->set('surly_initial', '2-2');
		}

		$json_response->send(array('success' => true));
	}

	public function ajax_save_trusted_groups()
	{
		$this->save_trusted_groups();
		$this->config->set('surly_initial', '4-1');

		$json_response = new \phpbb\json_response;
		$json_response->send(array('success' => true));
	}

	public function ajax_save_shorten_urls()
	{
		$this->save_shorten_urls();
		$this->config->set('surly_initial', '4-2');

		$json_response = new \phpbb\json_response;
		$json_response->send(array('success' => true));
	}

	public function ajax_save_replace_urls()
	{
		$this->save_replace_urls();
		$this->config->set('surly_initial', false);

		$sql = 'UPDATE ' . MODULES_TABLE . ' SET module_display = 1 WHERE module_langname = "ACP_SURLY_TAB_TOOLBAR_SETTINGS"';
		$this->db->sql_query($sql);

		$module_manager = $this->container->get('module.manager');
		$module_manager->remove_cache_file('acp');

		$this->surly->trackHistory(\surly\surly\operators\surly_phpbb::SURLY_ACTION_TYPE_ACTIVATION);

		$json_response = new \phpbb\json_response;
		$json_response->send(array('success' => true));
	}

	public function ajax_skip_step()
	{
		$steps = array('1-0', '2-1', '2-2', '3-0', '4-1', '4-2');

		$next_step = $this->request->variable('next_step', '1-0');
		$next_step = in_array($next_step, $steps) ? $next_step : $steps[0];
		
		$this->config->set('surly_initial', $next_step);

		$json_response = new \phpbb\json_response;
		$json_response->send(array('success' => true));
	}

	public function ajax_save_settings()
	{
		$json_response = new \phpbb\json_response;

		$this->save_replace_urls();
		$this->save_shorten_urls();
		$this->save_trusted_groups();

		$result = $this->save_subdomain();

		if (isset($result['error'])) {
			$json_response->send(array('error' => array('subdomain' => $result['error'])));
		}

		$json_response->send(array('success' => true));
	}

	public function ajax_save_trusted_domain()
	{
		$json_response = new \phpbb\json_response;

		$surly_trusted_domains = $this->config->offsetGet('surly_ignore_domains')
			? json_decode($this->config['surly_ignore_domains'], true) : array();

		$trusted_domain = preg_replace('/^https?:\/\/(.+)/',"$1", strtolower($this->request->variable('surly_trusted_domain', '')));

		if (empty($trusted_domain))
		{
			$json_response->send(array('error' => $this->user->lang('ACP_SURLY_ERROR_DOMAIN_NAME')));
		}

		if (preg_match('!(?P<host>(?:[a-z0-9_-]+\.)+[a-z]+)!u', $trusted_domain, $result))
		{
			$trusted_domain = $result['host'];
		}
		else
		{
			$json_response->send(array('error' => $this->user->lang('ACP_SURLY_ERROR_DOMAIN_NAME')));
		}		

		if (in_array($trusted_domain, $surly_trusted_domains))
		{
			$json_response->send(array('error' => $this->user->lang('ACP_SURLY_ERROR_DOMAIN_EXIST')));
		}

		$this->config->set('surly_ignore_domains',
			json_encode(array_merge($surly_trusted_domains, array($trusted_domain)))
		);

		$json_response->send(array('domain' => $trusted_domain));
	}

	public function ajax_delete_trusted_domains()
	{
		$surly_trusted_domains = $this->config->offsetGet('surly_ignore_domains')
			? json_decode($this->config['surly_ignore_domains'], true) : array();

		$trusted_domains = (array) $this->request->variable('surly_trusted_domains', array(0 => ''));

		$this->config->set('surly_ignore_domains',
			json_encode(array_diff($surly_trusted_domains, $trusted_domains))
		);

		$json_response = new \phpbb\json_response;
		$json_response->send(array('success' => true));
	}

	protected function save_replace_urls()
	{
		$surly_replace_urls = (array) $this->request->variable('surly_replace_urls', array(self::SURLY_REPLACE_URLS_NOWHERE));
		$surly_replace_urls = array_intersect(array(self::SURLY_REPLACE_URLS_NOWHERE), $surly_replace_urls)
			?: array_intersect(array(self::SURLY_REPLACE_URLS_POSTS), $surly_replace_urls)
			?: array(self::SURLY_REPLACE_URLS_NOWHERE);

		$this->config->set('surly_replace_urls', json_encode($surly_replace_urls));
	}

	protected function save_subdomain()
	{
		$surly_subdomain = $this->request->variable('surly_subdomain', '');

		if ($surly_subdomain != $this->config->offsetGet('surly_subdomain'))
		{
			if ($surly_subdomain == '')
			{
				$this->surly->trackHistory(\surly\surly\operators\surly_phpbb::SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK);
			}
			else
			{
				$result = json_decode($this->surly->linkSubdomain($surly_subdomain), true);

				if (isset($result['error_code']))
				{
					$errors = array(
						1 => $this->user->lang('ACP_SURLY_ERROR_SUBDOMAIN_REQUIRE'),
						2 => $this->user->lang('ACP_SURLY_ERROR_SUBDOMAIN_INVALID'),
						3 => $this->user->lang('ACP_SURLY_ERROR_SUBDOMAIN_EXIST'),
						4 => $this->user->lang('ACP_SURLY_ERROR_SUBDOMAIN_CNAME'),
						5 => $this->user->lang('ACP_SURLY_ERROR_UNEXPECTED'),
					);

					return isset($errors[$result['error_code']])
						? array('error' => $errors[$result['error_code']]) : array('error' => $errors[5]);
				}
				elseif (isset($result['subdomain'])) {
					$surly_subdomain = $result['subdomain'];

					$this->surly->trackHistory(\surly\surly\operators\surly_phpbb::SURLY_ACTION_TYPE_SUBDOMAIN_LINK);
				}
				else {
					$surly_subdomain = $this->config->offsetGet('surly_subdomain');
				}
			}
		}

		$this->config->set('surly_subdomain', $surly_subdomain);
	}

	protected function save_trusted_groups()
	{
		$surly_trusted_groups = (array) $this->request->variable('surly_trusted_groups', array(0));

		$groups_sql = 'SELECT DISTINCT g.group_type, g.group_name, g.group_id
			FROM ' . GROUPS_TABLE . ' g
			ORDER BY g.group_type DESC, g.group_name ASC';

		$groups = $this->db->sql_query($groups_sql);

		$group_ids = array();

		while ($row = $this->db->sql_fetchrow($groups))
		{
			$group_ids[] = $row['group_id'];
		}

		foreach ($surly_trusted_groups as $key => $value)
		{
			if (!in_array($value, $group_ids))
			{
				unset($surly_trusted_groups[$key]);
			}
		}

		$this->config->set('surly_trusted_groups', json_encode($surly_trusted_groups));
	}

	protected function save_shorten_urls()
	{
		$this->config->set('surly_shorten_urls', $this->request->variable('surly_shorten_urls', false));
	}
}
