<?php
/*
 * Copyright (c) 2012 Sur.ly
 * This file is part of Sur.ly phpBB plugin.
 * 
 * Sur.ly phpBB plugin plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Sur.ly phpBB plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Sur.ly phpBB plugin.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @author Sur.ly support@surdotly.com
 * @version $Id$
 * @copyright (c) 2012 Sur.ly
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 *
 */

/**
 * @ignore
 */
define('UMIL_AUTO', true);
define('IN_PHPBB', true);
define('IN_INSTALL', true);
$phpbb_root_path = (defined('PHPBB_ROOT_PATH')) ? PHPBB_ROOT_PATH : '../';
$phpEx = substr(strrchr(__FILE__, '.'), 1);

include($phpbb_root_path . 'common.' . $phpEx);
include($phpbb_root_path . 'includes/functions_surly.' . $phpEx);
$user->session_begin();
$auth->acl($user->data);
$user->setup();


if (!file_exists($phpbb_root_path . 'umil/umil_auto.' . $phpEx))
{
	trigger_error('Please download the latest UMIL (Unified MOD Install Library) from: <a href="http://www.phpbb.com/mods/umil/">phpBB.com/mods/umil</a>', E_USER_ERROR);
}

include($phpbb_root_path . 'includes/configuration_surly.' . $phpEx);

$action = request_var('action', '');

if ($action && confirm_box(true))
{
	$surly = surly_get_sdk();

	if ($action == 'install')
	{
		$surly->trackHistory(SURLY_ACTION_TYPE_INSTALL);
	}
	elseif ($action == 'uninstall')
	{
		$surly->trackHistory(SURLY_ACTION_TYPE_UNINSTALL);
	}
}

// Include the UMIL Auto file, it handles the rest
include($phpbb_root_path . 'umil/umil_auto.' . $phpEx);

// clear cache
cache_purge('', 0);
cache_purge('auth', 0);

?>