<?php

/*
 * Copyright (c) 2012 Sur.ly
 * This file is part of Sur.ly phpBB plugin.
 *
 * Sur.ly phpBB plugin plugin is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * Sur.ly phpBB plugin is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Sur.ly phpBB plugin.  If not, see <http://www.gnu.org/licenses/>.
 */

if (!defined('IN_PHPBB'))
{
	exit;
}

global $table_prefix;

define('SURLY_CACHE_TABLE',  $table_prefix . 'surly_cache');

define('SURLY_ACTION_TYPE_INSTALL', 1);
define('SURLY_ACTION_TYPE_AUTH', 2);
define('SURLY_ACTION_TYPE_ACTIVATION', 3);
define('SURLY_ACTION_TYPE_DEACTIVATION', 4);
define('SURLY_ACTION_TYPE_UNINSTALL', 5);
define('SURLY_ACTION_TYPE_SUBDOMAIN_LINK', 6);
define('SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK', 7);

if (!isset($phpbb_root_path))
{
	$phpbb_root_path = (defined('PHPBB_ROOT_PATH')) ? PHPBB_ROOT_PATH : './';
}

include($phpbb_root_path . 'includes/lib/surly-sdk-php/surly/Surly.' . $phpEx);
include($phpbb_root_path . 'includes/lib/surly-sdk-php/surly/JSON.' . $phpEx);

class surly_phpbb extends Surly
{
	var $root_status_key = 'surly_root_status';
	var $isRootDomainAlive = null;

	function cacheShortIds($url2shortIds)
	{
		global $db;

		foreach ($url2shortIds as $url => $id)
		{
			if (strlen($url) <= 255)
			{
				$db->sql_query('INSERT IGNORE
					INTO ' . SURLY_CACHE_TABLE . ' '
					. $db->sql_build_array('INSERT', array(
						'long_url' => $url,
						'hash' => $this->_md5($url),
						'short_id' => $id,
					))
				);
			}
		}

		parent::cacheShortIds($url2shortIds);
	}

	function getCachedShortIds($urls)
	{
		global $db;

		$result = parent::getCachedShortIds($urls);

		if (!empty($urls))
		{
			$where = array();

			foreach ($urls as $url)
			{
				if (!empty($url))
				{
					$val = array(
						'sc.long_url' => $url,
						'sc.hash' => $this->_md5($url),
					);
					$where[] = '(' . $db->sql_build_array('SELECT', $val) . ')';
				}
			}

			if (!empty($where))
			{
				$where_sql = implode(' OR ', $where);

				$sql = 'SELECT *
					FROM ' . SURLY_CACHE_TABLE . ' sc
					WHERE ' . $where_sql;

				$sql_result = $db->sql_query($sql);

				while ($row = $db->sql_fetchrow($sql_result))
				{
					$result[$row['long_url']] = $row['short_id'];
				}
				$db->sql_freeresult($sql_result);
			}
		}

		return $result;
	}

	function getCachedRootStatus()
	{
		global $config;

		if (!empty($config[$this->root_status_key]))
		{
			return $config[$this->root_status_key];
		}

		return false;
	}

	function cacheRootStatus($rootStatus)
	{
		set_config($this->root_status_key, $rootStatus);
	}

	function _md5($url)
	{
		$hash = md5($url);
		$result = '';

		for ($i = 0; $i < 32; $i+=2)
		{
			$digits = substr($hash, $i, 2);
			$number = hexdec($digits);
			$result.=chr($number);
		}

		return $result;
	}

	function trackHistory($actionType)
	{
		global $config;

		$this->timeout = SURLY_API_TRACK_TIMEOUT;

		$this->_performRequest(
			$this->apiHost . SURLY_API_TRACK_HISTORY_PATH,  'POST',
				array(
					'action_type' => $actionType,
					'site_url' => generate_board_url(true),
					'toolbar_id' => !empty($config['surly_toolbar_id']) ? $config['surly_toolbar_id'] : '',
					'hash' => !empty($config['surly_activation_hash']) ? $config['surly_activation_hash'] : '',
				)
		);

		$this->timeout = SURLY_API_TIMEOUT;
	}

	function linkSubdomain($subdomain)
	{
		global $config;

		return $this->_performRequest(
			$this->apiHost . SURLY_API_SUBDOMAIN_LINK, 'POST',
				array(
					'toolbar_id' => !empty($config['surly_toolbar_id']) ? $config['surly_toolbar_id'] : '',
					'password' => !empty($config['surly_toolbar_password']) ? $config['surly_toolbar_password'] : '',
					'subdomain' => $subdomain,
				)
		);
	}

	function getSurlyApiUseragent()
	{
		return 'surly_api_caller (running ' . str_replace(array('http://', 'https://'), array('', ''), generate_board_url()) . ')';
	}
}

?>
