<?php

if (!defined('IN_PHPBB'))
{
	exit;
}

// The name of the mod to be displayed during installation.
$mod_name = 'surly';

/*
 * The name of the config variable which will hold the currently installed version
 * UMIL will handle checking, setting, and updating the version itself.
 */
$version_config_name = 'surly_version';

// The language file which will be included when installing
$language_file = 'mods/info_acp_surly';

/*
 * Optionally we may specify our own logo image to show in the upper corner instead of the default logo.
 * $phpbb_root_path will get prepended to the path specified
 * Image height should be 50px to prevent cut-off or stretching.
 */
//$logo_img = 'styles/prosilver/imageset/site_logo.gif';

/*
 * The array of versions and actions within each.
 * You do not need to order it a specific way (it will be sorted automatically), however, you must enter every version, even if no actions are done for it.
 *
 * You must use correct version numbering.  Unless you know exactly what you can use, only use X.X.X (replacing X with an integer).
 * The version numbering must otherwise be compatible with the version_compare function - http://php.net/manual/en/function.version-compare.php
 */

$surly_cat_data = array(
	'module_enabled' => true,
	'module_display' => true,
	'module_langname' => 'ACP_CAT_SURLY',
	'module_auth' => 'acl_a_surly',
);

$surly_module_data = array(
	'module_enabled' => true,
	'module_display' => true,
	'module_langname' => 'ACP_SURLY_MODULE',
	'module_auth' => 'acl_a_surly',
);

$surly_settings_plugin_module_data = array(
	'module_enabled' => true,
	'module_display' => true,
	'module_langname' => 'ACP_SURLY_TAB_PLUGIN_SETTINGS',
	'module_basename' => 'surly',
	'module_mode' => 'surly-settings-plugin',
	'module_auth' => 'acl_a_surly',
);

$surly_settings_toolbar_module_data = array(
	'module_enabled' => true,
	'module_display' => false,
	'module_langname' => 'ACP_SURLY_TAB_TOOLBAR_SETTINGS',
	'module_basename' => 'surly',
	'module_mode' => 'surly-settings-toolbar',
	'module_auth' => 'acl_a_surly',
);

$schema_data = array(
	'COLUMNS' => array(
		'long_url' => array('VCHAR:255', ''),
		'hash' => array('VARBINARY', ''),
		'short_id' => array('VCHAR:10', ''),
	),
	'KEYS' => array(
		'idx' => array('UNIQUE', array('hash', 'long_url(100)'))
	),
);

$versions = array(
	'3.0.0' => array(
		'permission_add' => array(
			array('a_surly', true),
		),
		'module_add' => array(
			array('acp', false, $surly_cat_data),
			array('acp', 'ACP_CAT_SURLY', $surly_module_data),
			array('acp', 'ACP_SURLY_MODULE', $surly_settings_plugin_module_data),
			array('acp', 'ACP_SURLY_MODULE', $surly_settings_toolbar_module_data),
		),
		'table_add' => array(
			array('phpbb_surly_cache', $schema_data),
		),
		'config_add' => array(
			array('surly_shorten_urls', false),
			array('surly_trusted_groups', ''),
			array('surly_ignore_domains', ''),
			array('surly_subdomain', ''),
			array('surly_activation_hash', md5(time())),
			array('surly_replace_urls', ''),
			array('surly_initial', ''),
			array('surly_toolbar_id', ''),
			array('surly_toolbar_password', ''),
		),
	),
);

?>
