<?php

defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

use Joomla\Registry\Registry;

JLoader::register('SurlyJoomla', JPATH_LIBRARIES . '/surly/SurlyJoomla.php');

class plgContentSurly extends JPlugin
{
	var $comParams;

	function plgContentSurly(&$subject, $config)
	{
		if (JComponentHelper::isEnabled('com_surly') && class_exists('SurlyJoomla')) {
			$this->comParams = SurlyJoomla::instance()->getParams();
		}
		else {
			$this->comParams = new Registry;
		}

		parent::__construct($subject, $config);
	}

	function isWhitelistedUser($userId)
	{
		$user = & JFactory::getUser($userId);

		if (array_intersect($user->groups, $this->comParams->get('surly_trusted_groups', array()))) {
			return true;
		}

		return false;
	}

	function onContentBeforeDisplay($context, &$row, &$params, $limitstart)
	{
		if (in_array(1, $this->comParams->get('surly_replace_urls', array(0)))) {

			if (isset($row->created_by) && !$this->isWhitelistedUser($row->created_by)) {
				SurlyJoomla::instance()->setCacheId($row->id);

				if (isset($row->text)) {
					$row->text = SurlyJoomla::instance()->process($row->text);
				}

				if (isset($row->introtext)) {
					$row->introtext = SurlyJoomla::instance()->process($row->text);
				}
			}
		}
	}

	function onJCommentsCommentAfterPrepare($row)
	{
		if (in_array(2, $this->comParams->get('surly_replace_urls', array(0)))) {

			if (isset($row->userid) && !$this->isWhitelistedUser($row->userid)) {
				SurlyJoomla::instance()->setCacheId($row->object_group . '-' . $row->object_id);

				$row->comment = SurlyJoomla::instance()->process($row->comment);

				if (!empty($row->homepage)) {
					$row->homepage = SurlyJoomla::instance()->processUrl($row->homepage);
				}
			}
		}
	}

	function onBeforeKomentoItemContent($params)
	{
		if (in_array(2, $this->comParams->get('surly_replace_urls', array(0)))) {

			$row = $params['comment'];

			if (isset($row->created_by) && !$this->isWhitelistedUser($row->created_by)) {
				SurlyJoomla::instance()->setCacheId($row->component . '-' . $row->cid);

				$row->comment = SurlyJoomla::instance()->process($row->comment);
			}
		}
	}
}
