<?php

defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

JLoader::register('SurlyJoomla', JPATH_SITE . DS . 'components' . DS . 'com_surly' . DS . 'libraries' . DS . 'SurlyJoomla.php');

class plgContentSurly extends JPlugin
{
	var $comParams;

	function plgContentSurly(&$subject, $config)
	{
		$this->comParams = SurlyJoomla::instance()->getParams();

		parent::__construct($subject, $config);
	}

	function isWhitelistedUser($userId)
	{
		$user = & JFactory::getUser($userId);

		if (array_intersect((array) $user->gid, (array) $this->comParams->get('surly_trusted_groups', array()))) {
			return true;
		}

		return false;
	}

	function onPrepareContent(&$article, &$params, $limitstart)
	{
		if (in_array(1, (array) $this->comParams->get('surly_replace_urls', array(0)))) {

			if (isset($article->created_by) && !$this->isWhitelistedUser($article->created_by)) {
				SurlyJoomla::instance()->setCacheId($row->id);

				if (isset($article->text)) {
					$article->text = SurlyJoomla::instance()->process($article->text);
				}

				if (isset($article->introtext)) {
					$row->introtext = SurlyJoomla::instance()->process($row->article);
				}
			}
		}
	}

	function onJCommentsCommentAfterPrepare($row)
	{
		if (in_array(2, (array) $this->comParams->get('surly_replace_urls', array(0)))) {

			if (isset($row->userid) && !$this->isWhitelistedUser($row->userid)) {
				SurlyJoomla::instance()->setCacheId($row->object_group . '-' . $row->object_id);

				$row->comment = SurlyJoomla::instance()->process($row->comment);

				if (!empty($row->homepage)) {
					$row->homepage = SurlyJoomla::instance()->processUrl($row->homepage);
				}
			}
		}
	}
}
