<?php

defined('_JEXEC') or die;

define('ONE_YEAR', 365 * 24 * 60);

jimport('joomla.cache.cache');

JLoader::register('Surly', JPATH_SITE . DS . 'components' . DS . 'com_surly' . DS . 'libraries' . DS . 'surly-sdk-php' . DS . 'surly' . DS . 'Surly.php');

class SurlyJoomla extends Surly
{
	const CACHE_GROUP = 'surly';
	const SURLY_ACTION_TYPE_INSTALL = 1;
	const SURLY_ACTION_TYPE_AUTH = 2;
	const SURLY_ACTION_TYPE_ACTIVATION = 3;
	const SURLY_ACTION_TYPE_DEACTIVATION = 4;
	const SURLY_ACTION_TYPE_UNINSTALL = 5;
	const SURLY_ACTION_TYPE_SUBDOMAIN_LINK = 6;
	const SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK = 7;

	static protected $instance;

	public $isRootDomainAlive = null;
	protected $params;
	protected $cache;
	protected $cacheId;

	public static function instance()
	{
		if (empty(static::$instance)) {
			$params = JComponentHelper::getParams('com_surly');

			static::$instance = new static($params->get('surly_toolbar_id', SURLY_DEFAULT_TOOLBAR_ID), $params->get('surly_shorten_urls', false));

			if ($surlySubdomain = $params->get('surly_subdomain', '')) {
				static::$instance->setPanelHost($surlySubdomain);
			}

			foreach ((array) $params->get('surly_trusted_domains', array()) as $domain) {
				static::$instance->whitelist($domain);
			}

			$baseUrl = parse_url(JURI::root(), PHP_URL_HOST);

			static::$instance->whitelist($baseUrl);

			static::$instance
				->setParams($params)
				->initCache();
			
		}

		return static::$instance;
	}

	public function setParams($params)
	{
		$this->params = $params;

		return $this;
	}

	public function getParams()
	{
		return $this->params;
	}

	public function initCache()
	{
		$this->cache = new JCache(array('caching' => true, 'lifetime' => ONE_YEAR));

		return $this;
	}

	public function setCacheId($id)
	{
		$this->cacheId = $id;

		return $this;
	}

	public function getCachedShortIds($urls)
	{
		$result = parent::getCachedShortIds($urls);

		$cached = $this->cache->get($this->cacheId, static::CACHE_GROUP);

		if ($cached) {
			$cachedUrls = unserialize($cached);

			foreach ($urls as $url) {
				if (isset($cachedUrls[$url])) {
					$result[$url] = $cachedUrls[$url];
				}
			}
		}

		return $result;
	}

	public function cacheShortIds($url2shortIds)
	{
		$cached = $this->cache->get($this->cacheId, static::CACHE_GROUP);

		$cachedUrls = array();

		if ($cached) {
			$cachedUrls = unserialize($cached);
		}

		$caching = array_merge($cachedUrls, $url2shortIds);

		$this->cache->store(serialize($caching), $this->cacheId, static::CACHE_GROUP);

		parent::cacheShortIds($url2shortIds);
	}

	public function linkSubdomain($subdomain)
	{
		return $this->_performRequest(
			$this->apiHost . SURLY_API_SUBDOMAIN_LINK, 'POST',
				array(
					'toolbar_id' => $this->params->get('surly_toolbar_id', ''),
					'password' => $this->params->get('surly_toolbar_password', ''),
					'subdomain' => $subdomain,
				)
		);
	}

	public function trackHistory($actionType)
	{
		$this->timeout = SURLY_API_TRACK_TIMEOUT;

		$this->_performRequest(
			$this->apiHost . SURLY_API_TRACK_HISTORY_PATH,  'POST',
				array(
					'action_type' => $actionType,
					'site_url' => JURI::root(),
					'toolbar_id' => $this->params->get('surly_toolbar_id', ''),
					'hash' => $this->params->get('surly_activation_hash', ''),
				)
		);

		$this->timeout = SURLY_API_TIMEOUT;
	}
}
