<?php

defined( '_JEXEC' ) or die( 'Restricted access' );

class JHtmlSurly
{
	function &usergroups($selected = array())
	{
		$db = JFactory::getDbo();
		$db->setQuery('SELECT a.name, a.name AS text, a.id, COUNT(DISTINCT b.id) AS level' 
				. ' FROM #__core_acl_aro_groups AS a'
				. ' LEFT JOIN `#__core_acl_aro_groups` AS b ON a.lft > b.lft AND a.rgt < b.rgt'
				. ' WHERE a.name NOT IN ("ROOT", "USERS", "Public Backend")'
				. ' GROUP BY a.id'
				. ' ORDER BY a.lft ASC');
		$groups = $db->loadObjectList();

		self::updateUserGroups($groups);

		$html = array();

		for ($i = 0, $n = count($groups); $i < $n; $i++) {
			$item = & $groups[$i];

			$html[] = '<li>'
				. '<label for="surly_trusted_groups-' . $item->id . '">'
					. str_repeat('-', $item->level) . ' ' . $item->name
				. '</label>'
				. '<input type="checkbox" id="surly_trusted_groups-' . $item->id . '" name="surly_trusted_groups[]" value="' . $item->id . '"' . (in_array($item->id, $selected) ? ' checked="checked"' : '') . '/>'
			. '</li>';
		}

		return implode("\n", $html);
	}

	function updateUserGroups(&$groups)
	{
		if (is_array($groups)) {
			foreach ($groups as &$group) {
				if ($group->text == 'Public Frontend') {
					$group->name = 'Public';
					$group->text = 'Unregistered';
				} else if ($group->text == 'Super Administrator') {
					$group->name = 'Super Users';
				}
				$group->level = $group->level - 2;
			}
		}
	}

}
