<?php

class surly_settings_plugin extends output
{
    public function show($surlyReplaceUrls, $surlyTrustedDomains, $surlyTrustedDomainsLength, $surlyTrustedGroups, $surlySubdomain) {
        $IPBHTML = '';

        $IPBHTML .= <<<EOF
        <div class="ipsTabBar">
            <ul>
                <li class="active">{$this->lang->words['surly_tab_plugin_settings']}</li>
                <li><a href="{$this->settings['base_url']}{$this->form_code}module=surly&section=surly&do=settings-toolbar">{$this->lang->words['surly_tab_toolbar_settings']}</a></li>
            </ul>
        </div>
        <div class="wrapper-surly" data-surly-module-url="{$this->settings['base_url']}{$this->form_code_js}section=surly&module=ajax&">
            <div class="ps-window">
                <div class="ps-central-content">
                    <div class="ps-rows-settings">
                        <form id="surly-save-settings-form">
                            <div id="surly-replace-urls" class="ps-row-box">
                                <div class="ps-inner-box">
                                    <div class="ps-title-box">
                                        <p>{$this->lang->words['surly_title_replace_urls']}</p>
                                    </div>
                                    <div class="ps-table-box">
                                        <div class="ps-cell">
                                            <div class="w280">
EOF;
                                            if (in_array(0, $surlyReplaceUrls)) {
                                                $IPBHTML .= <<<EOF
                                                <div class="ps-list-in field-error">
EOF;
                                            } else {
                                                $IPBHTML .= <<<EOF
                                                <div class="ps-list-in">
EOF;
                                            }
                                                $IPBHTML .= <<<EOF
                                                    <ul>
                                                        <li>
                                                            <label for="surly_replace_urls_nowhere">{$this->lang->words['surly_option_nowhere']}</label>
                                                            <input
EOF;
                                                            if (in_array(0, $surlyReplaceUrls)) {
                                                                $IPBHTML .= <<<EOF
                                                                checked="checked"
EOF;
                                                            }
                                                            $IPBHTML .= <<<EOF
                                                                id="surly_replace_urls_nowhere"
                                                                name="surly_replace_urls[]"
                                                                value="0"
                                                                type="checkbox"/>
                                                        </li>
                                                        <li>
                                                            <label for="surly_replace_urls_posts">{$this->lang->words['surly_option_posts']}</label>
                                                            <input
EOF;
                                                            if (in_array(1, $surlyReplaceUrls)) {
                                                                $IPBHTML .= <<<EOF
                                                                checked="checked"
EOF;
                                                            }
                                                            $IPBHTML .= <<<EOF
                                                                id="surly_replace_urls_posts"
                                                                name="surly_replace_urls[]"
                                                                value="1"
                                                                type="checkbox"/>
                                                        </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ps-cell">
                                            <div class="surly-field-error" data-field="surly-replace-urls">
EOF;
                                            if (in_array(0, $surlyReplaceUrls)) {
                                                $IPBHTML .= <<<EOF
                                                <div class="ps-title-cell red show">
EOF;
                                            } else  {
                                                $IPBHTML .= <<<EOF
                                                <div class="hide">
EOF;
                                            }
                                                $IPBHTML .= <<<EOF
                                                    <p>{$this->lang->words['surly_message_configuration_surly']}</p>
                                                </div>
                                            </div>
                                            <div class="ps-title-cell">
                                                <p>{$this->lang->words['surly_description_replace_urls']}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ps-row-box">
                                <div class="ps-inner-box">
                                    <div class="ps-title-box">
                                        <p>{$this->lang->words['surly_title_shorten_urls']}</p>
                                    </div>
                                    <div class="ps-cell">
                                        <div class="w280">
                                            <div class="ps-cell">
                                                <div class="ps-select-in">
                                                    <select name="surly_shorten_urls">
                                                        <option
EOF;
                                                        if (!$this->settings['surly_shorten_urls']) {
                                                            $IPBHTML .= <<<EOF
                                                            selected="selected"
EOF;
                                                        }
                                                        $IPBHTML .= <<<EOF
                                                            value="0">
                                                            {$this->lang->words['surly_option_disable']}
                                                        </option>
                                                        <option
EOF;
                                                        if ($this->settings['surly_shorten_urls']) {
                                                            $IPBHTML .= <<<EOF
                                                            selected="selected"
EOF;
                                                        }
                                                        $IPBHTML .= <<<EOF
                                                            value="1">
                                                            {$this->lang->words['surly_option_enable']}
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ps-cell">
                                        <div class="ps-title-cell">
                                            <p>{$this->lang->words['surly_description_shorten_urls']}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div id="surly-subdomain" class="ps-row-box">
                                <div class="ps-inner-box">
                                    <div class="ps-title-box">
                                        <p>{$this->lang->words['surly_title_subdomain']}</p>
                                    </div>
                                    <div class="ps-table-box">
                                        <div class="ps-cell">
                                            <div class="w280">
                                                <div class="ps-type-in">
                                                    <input name="surly_subdomain" value="{$surlySubdomain}" type="text" placeholder="{$this->lang->words['surly_placeholder_url']}"/>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ps-cell">
                                            <div class="surly-field-error" data-field="surly-subdomain"></div>
                                            <div class="ps-title-cell">
                                                <p>{$this->lang->words['surly_description_subdomain']}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="ps-row-box">
                                <div class="ps-inner-box">
                                    <div class="ps-title-box">
                                        <p>{$this->lang->words['surly_title_trusted_groups']}</p>
                                    </div>
                                    <div class="ps-table-box">
                                        <div class="ps-cell">
                                            <div class="w280">
                                                <div class="ps-list-in trusted-groups">
                                                    <ul>
EOF;
                                                    foreach (ipsRegistry::cache()->getCache( 'group_cache' ) as $key => $value) {
                                                        $IPBHTML .= <<<EOF
                                                        <li>
                                                            <label for="surly_trusted_groups-{$key}">
                                                                {$value['g_title']}
                                                            </label>
                                                            <input
EOF;
                                                            if (in_array($key, $surlyTrustedGroups)) {
                                                                $IPBHTML .= <<<EOF
                                                                checked="checked"
EOF;
                                                            }
                                                            $IPBHTML .= <<<EOF
                                                                id="surly_trusted_groups-{$key}"
                                                                name="surly_trusted_groups[]"
                                                                value="{$key}"
                                                                type="checkbox"/>
                                                        </li>
EOF;
                                                    }
                                                    $IPBHTML .= <<<EOF
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ps-cell">
                                            <div class="ps-title-cell">
                                                <p>{$this->lang->words['surly_description_trusted_groups']}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                        <form id="surly-trusted-domains">
                            <div class="ps-row-box">
                                <div class="ps-inner-box">
                                    <div class="ps-title-box">
                                        <p>{$this->lang->words['surly_title_trusted_domains']}</p>
                                    </div>
                                    <div class="ps-table-box">
                                        <div class="ps-cell">
                                            <div class="w430">
                                                <div class="ps-type-in">
                                                    <input id="surly-trusted-domain" name="surly_trusted_domain" value="" placeholder="{$this->lang->words['surly_placeholder_domain']}"/>
                                                    <div class="ps-type-buttons">
                                                        <a id="surly-save-trusted-domain" href="#" class="ps-type-button blue">{$this->lang->words['surly_button_add_domain']}</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="ps-cell">
                                            <div class="surly-field-error" data-field="surly-trusted-domain"></div>
                                            <div class="ps-title-cell">
                                                <p>{$this->lang->words['surly_description_trusted_domains']}</p>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="ps-central-box">
                                        <div class="ps-table-line">
                                            <ul>
                                                <li class="first">
                                                    <span class="ps-type-check">
                                                        <input type="checkbox" value="1" id="surly_trusted_domains"/>
                                                    </span>
                                                    <label for="surly_trusted_domains">{$this->lang->words['surly_label_domain']}</label>
                                                    <span class="num-item">
EOF;
                                                    if ($surlyTrustedDomainsLength == 1) {
                                                        $IPBHTML .= <<<EOF
                                                        1 {$this->lang->words['surly_label_item']}
EOF;
                                                    } else {
                                                        $IPBHTML .= <<<EOF
                                                        {$surlyTrustedDomainsLength} {$this->lang->words['surly_label_items']}
EOF;
                                                    }
                                                    $IPBHTML .= <<<EOF
                                                    </span>
                                                </li>
EOF;
                                                foreach ($surlyTrustedDomains as $key => $value) {
                                                    $IPBHTML .= <<<EOF
                                                    <li class="inner">
                                                        <span class="ps-type-check">
                                                            <input
                                                                id="surly_trusted_domains-{$key}"
                                                                name="surly_trusted_domains[]"
                                                                value="{$value}"
                                                                type="checkbox"/>
                                                        </span>
                                                        <label for="surly_trusted_domains-{$key}">{$value}</label>
                                                    </li>
EOF;
                                                }
                                                if ($surlyTrustedDomainsLength) {
                                                    $IPBHTML .= <<<EOF
                                                    <li class="empty hide">
EOF;
                                                } else {
                                                    $IPBHTML .= <<<EOF
                                                    <li class="empty">
EOF;
                                                }
                                                $IPBHTML .= <<<EOF
                                                    <label>{$this->lang->words['surly_label_no_items_found']}</label>
                                                </li>
                                            </ul>
                                            <div class="ps-type-buttons">
                                                <a id="surly-delete-trusted-domains" href="#" class="ps-type-button ps-border lred pad30">{$this->lang->words['surly_button_delete']}</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="ps-type-buttons">
                        <a id="surly-save-settings" href="#" class="ps-type-button blue">{$this->lang->words['surly_button_save_changes']}</a>
                    </div>
                </div>
            </div>
        </div>

        <script type="text/javascript" src="{$this->settings['skin_app_url']}static/js/chosen.jquery.min.js"></script>
        <script type="text/javascript" src="{$this->settings['skin_app_url']}static/js/jquery.icheck.min.js"></script>
        <script type="text/javascript" src="{$this->settings['skin_app_url']}static/js/jquery.postMessage.min.js"></script>
        <script type="text/javascript" src="{$this->settings['skin_app_url']}static/js/surly-script.js"></script>
EOF;

        return $IPBHTML;
    }
}