<?php

require_once IPSLib::getAppDir( 'surly' ) . '/extensions/surly.php';

class admin_surly_ajax_surly extends ipsAjaxCommand 
{
    public function doExecute( ipsRegistry $registry )
    {
        $this->registry->getClass('class_permissions')->checkPermissionAutoMsg( 'surly_manage' );
        $this->registry->getClass('class_localization')->loadLanguageFile( array( 'admin_surly' ) );

        switch( $this->request['do'] )
        {
            case 'ajaxSaveToolbarSettings':
                $this->ajaxSaveToolbarSettings();
            break;

            case 'ajaxSaveSubdomain':
                $this->ajaxSaveSubdomain();
            break;

            case 'ajaxSaveTrustedGroups':
                $this->ajaxSaveTrustedGroups();
            break;

            case 'ajaxSaveShortenUrls':
                $this->ajaxSaveShortenUrls();
            break;

            case 'ajaxSaveReplaceUrls':
                $this->ajaxSaveReplaceUrls();
            break;

            case 'ajaxSkipStep':
                $this->ajaxSkipStep();
            break;

            case 'ajaxSaveSettings':
                $this->ajaxSaveSettings();
            break;

            case 'ajaxSaveTrustedDomain':
                $this->ajaxSaveTrustedDomain();
            break;

            case 'ajaxDeleteTrustedDomains':
                $this->ajaxDeleteTrustedDomains();
            break;
        }
    }

    protected function saveSubdomain()
    {
        $surly_subdomain = isset( $this->request['surly_subdomain'] )
            ? $this->request['surly_subdomain']
            : '';

        if ( $surly_subdomain != ipsRegistry::$settings['surly_subdomain'] ) {
            $surly = surly_get_sdk();

            if ( $surly_subdomain == '' ) {
                $surly->trackHistory( SurlyIpb::SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK );
            }
            else {
                $result = json_decode( $surly->linkSubdomain($surly_subdomain), TRUE );

                if ( isset( $result['error_code'] ) ) {
                    $errors = array(
                        1 => $this->lang->words['surly_error_subdomain_require'],
                        2 => $this->lang->words['surly_error_subdomain_invalid'],
                        3 => $this->lang->words['surly_error_subdomain_exist'],
                        4 => $this->lang->words['surly_error_subdomain_cname'],
                        5 => $this->lang->words['surly_error_unexpected'],
                    );

                    return isset( $errors[$result['error_code']] )
                        ? array( 'error' => $errors[$result['error_code']] )
                        : array( 'error' => $errors[5] );
                }
                elseif ( isset( $result['subdomain'] ) ) {
                    $surly_subdomain = $result['subdomain'];

                    $surly->trackHistory( SurlyIpb::SURLY_ACTION_TYPE_SUBDOMAIN_LINK );
                }
                else {
                    $surly_subdomain = ipsRegistry::$settings['surly_subdomain'];
                }
            }
        }

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => $surly_subdomain ), "conf_key='surly_subdomain'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );
    }

    protected function saveTrustedGroups()
    {
        $surly_trusted_groups = isset( $this->request['surly_trusted_groups'] )
            ? (array) $this->request['surly_trusted_groups']
            : array();

        $groups = ipsRegistry::cache()->getCache( 'group_cache' );

        foreach ( $surly_trusted_groups as $key => $value ) {
            if ( !isset( $groups[$value] ) ) {
                unset( $surly_trusted_groups[$key] );
            }
        }

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => json_encode( $surly_trusted_groups ) ), "conf_key='surly_trusted_groups'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );
    }

    protected function saveShortenUrls()
    {
        $surly_shorten_urls = !empty( $this->request['surly_shorten_urls'] );

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => (int) $surly_shorten_urls ), "conf_key='surly_shorten_urls'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );
    }

    protected function saveReplaceUrls()
    {
        $surly_replace_urls = isset( $this->request['surly_replace_urls'] )
            ? (array) $this->request['surly_replace_urls']
            : array(0);

        $surly_replace_urls = array_intersect( array(0), $surly_replace_urls )
            ?: array_intersect( array(1), $surly_replace_urls )
            ?: array(0);

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => json_encode( $surly_replace_urls ) ), "conf_key='surly_replace_urls'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );
    }

    protected function ajaxSaveToolbarSettings()
    {
        $surly_toolbar_id = isset( $this->request['surly_toolbar_id'] )
            ? $this->request['surly_toolbar_id']
            : '';

        $surly_toolbar_password = isset( $this->request['surly_toolbar_password'] )
            ? $this->request['surly_toolbar_password']
            : '';

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => $surly_toolbar_id ), "conf_key='surly_toolbar_id'" );
        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => $surly_toolbar_password ), "conf_key='surly_toolbar_password'" );
        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => '2-1' ), "conf_key='surly_initial'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );

        $surly = surly_get_sdk();
        $surly->trackHistory( SurlyIpb::SURLY_ACTION_TYPE_AUTH );

        $this->returnJsonArray( array( 'success' => TRUE ) );
    }

    protected function ajaxSaveSubdomain()
    {
        $result = $this->saveSubdomain();

        if ( isset( $result['error'] ) ) {
            $this->returnJsonArray( array( 'error' => array( 'subdomain' => $result['error'] ) ) );
        }

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => '2-2' ), "conf_key='surly_initial'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );

        $this->returnJsonArray( array( 'success' => TRUE ) );
    }

    protected function ajaxSaveTrustedGroups()
    {
        $this->saveTrustedGroups();

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => '4-1' ), "conf_key='surly_initial'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );

        $this->returnJsonArray( array( 'success' => TRUE ) );
    }

    protected function ajaxSaveShortenUrls()
    {
        $this->saveShortenUrls();

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => '4-2' ), "conf_key='surly_initial'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );

        $this->returnJsonArray( array( 'success' => TRUE ) );
    }

    protected function ajaxSaveReplaceUrls()
    {
        $this->saveReplaceUrls();

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => 0 ), "conf_key='surly_initial'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );

        $surly = surly_get_sdk();
        $surly->trackHistory( SurlyIpb::SURLY_ACTION_TYPE_ACTIVATION );

        $this->returnJsonArray( array( 'success' => TRUE ) );
    }

    protected function ajaxSkipStep()
    {
        $steps = array( '1-0', '2-1', '2-2', '3-0', '4-1', '4-2' );

        $next_step = isset( $this->request['next_step'] ) && in_array( $this->request['next_step'], $steps )
            ? $this->request['next_step']
            : $steps[0];

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => $next_step ), "conf_key='surly_initial'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );

        $this->returnJsonArray( array( 'success' => TRUE ) );
    }

    protected function ajaxSaveSettings()
    {
        $this->saveReplaceUrls();
        $this->saveShortenUrls();
        $this->saveTrustedGroups();

        $result = $this->saveSubdomain();

        if ( isset( $result['error'] ) ) {
            $this->returnJsonArray( array( 'error' => array( 'subdomain' => $result['error'] ) ) );
        }

        $this->returnJsonArray( array( 'success' => TRUE ) );
    }

    protected function ajaxSaveTrustedDomain()
    {
        $trusted_domain = isset( $this->request['surly_trusted_domain'] )
            ? preg_replace('/^https?:\/\/(.+)/',"$1", strtolower( trim( $this->request['surly_trusted_domain'] ) ))
            : '';

        if ( empty( $trusted_domain ) ) {
            $this->returnJsonArray( array( 'error' => $this->lang->words['surly_error_domain_name'] ) );
        }

        if ( preg_match('!(?P<host>(?:[a-z0-9_-]+\.)+[a-z]+)!u', $trusted_domain, $result) ) {
            $trusted_domain = $result['host'];
        }
        else {
            $this->returnJsonArray( array( 'error' => $this->lang->words['surly_error_domain_name'] ) );
        }

        $surlyTrustedDomains = json_decode( ipsRegistry::$settings['surly_trusted_domains'], TRUE );

        if ( in_array($trusted_domain, $surlyTrustedDomains) ) {
            $this->returnJsonArray( array( 'error' => $this->lang->words['surly_error_domain_exist'] ) );
        }

        $surlyTrustedDomains = array_merge( $surlyTrustedDomains, array( $trusted_domain ) );

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => json_encode($surlyTrustedDomains) ), "conf_key='surly_trusted_domains'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );

        $this->returnJsonArray( array('domain' => $trusted_domain) );
    }

    protected function ajaxDeleteTrustedDomains()
    {
        $trusted_domains = isset( $this->request['surly_trusted_domains'] )
            ? (array) $this->request['surly_trusted_domains']
            : array();

        $surlyTrustedDomains = json_decode( ipsRegistry::$settings['surly_trusted_domains'], TRUE );

        $surlyTrustedDomains = array_diff( $surlyTrustedDomains, $trusted_domains );

        $this->DB->update( 'core_sys_conf_settings', array( 'conf_value' => json_encode($surlyTrustedDomains) ), "conf_key='surly_trusted_domains'" );

        ipsRegistry::cache()->rebuildCache( 'settings' );

        $this->returnJsonArray( array( 'success' => TRUE ) );
    }
}