<?php

require_once IPSLib::getAppDir( 'surly' ) . '/extensions/SurlyIpb.php';

function surly_get_sdk() {
    static $surly;

    if (!isset($surly)) {

        $surly = new SurlyIpb(
            ipsRegistry::$settings['surly_toolbar_id'],
            (bool) ipsRegistry::$settings['surly_shorten_urls']
        );

        if (ipsRegistry::$settings['surly_subdomain']) {
            $surly->setPanelHost(ipsRegistry::$settings['surly_subdomain']);
        }

        $surlyTrustedDomains = json_decode( ipsRegistry::$settings['surly_trusted_domains'], TRUE );

        foreach ($surlyTrustedDomains as $domain) {
            $surly->whitelist($domain);
        }

        $site_url = parse_url(ipsRegistry::$settings['_base_url'], PHP_URL_HOST);
        $surly->whitelist($site_url);
    }

    return $surly;
}

function getTrustedGroups() {
    return json_decode( ipsRegistry::$settings['surly_trusted_groups'], TRUE );
}

function isUserIgnored($authorId) {
    return IPSMember::isInGroup( $authorId, getTrustedGroups() );
}

function transformUrls($post, $authorId) {

    if ( in_array(1, json_decode( ipsRegistry::$settings['surly_replace_urls'], TRUE )) && !isUserIgnored( $authorId ) ) {
        $surly = surly_get_sdk();

        return $surly->process($post);
    }

    return $post;
}
