<?php

require_once IPSLib::getAppDir( 'surly' ) . '/sources/surly-sdk-php/surly/Surly.php';

class SurlyIpb extends Surly {
    
    const CMS_ID = 9;

    const SURLY_ACTION_TYPE_INSTALL = 1;
    const SURLY_ACTION_TYPE_AUTH = 2;
    const SURLY_ACTION_TYPE_ACTIVATION = 3;
    const SURLY_ACTION_TYPE_DEACTIVATION = 4;
    const SURLY_ACTION_TYPE_UNINSTALL = 5;
    const SURLY_ACTION_TYPE_SUBDOMAIN_LINK = 6;
    const SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK = 7;

    protected $rootStatusKey = 'surly_root_status';
    public $isRootDomainAlive = null;

    public function cacheShortIds($url2shortIds)
    {
        foreach ($url2shortIds as $url => $id) {
            ipsRegistry::DB()->replace('surly_cache', array( 
                'long_url' => $url, 
                'hash' => $this->_md5($url), 
                'short_id' => $id,
            ), array());
        }

        parent::cacheShortIds($url2shortIds);
    }

    public function getCachedShortIds($urls)
    {
        $result = parent::getCachedShortIds($urls);

        if (!empty($urls)) {
            $where = array();

            foreach ($urls as $url) {
                if (!empty($url)) {
                    $where[] = "(`hash` = '" . ipsRegistry::DB()->addSlashes($this->_md5($url)) . "' AND `long_url` = '" . ipsRegistry::DB()->addSlashes($url) . "')";
                }
            }

            if (!empty($where)) {
                $where_sql = implode(' OR ', $where);

                ipsRegistry::DB()->build(array(
                    'select'    => 'sc.*',
                    'from'  => array( 'surly_cache' => 'sc' ),
                    'where' => $where_sql,
                ));

                $o = ipsRegistry::DB()->execute();

                while($row = ipsRegistry::DB()->fetch($o)) {
                    $result[$row['long_url']] = $row['short_id'];
                }
            }
        }

        return $result;
    }

    public function getCachedRootStatus()
    {
        if (!empty(ipsRegistry::$settings[$this->rootStatusKey])) {
            return ipsRegistry::$settings[$this->rootStatusKey];
        }

        return false;
    }

    public function cacheRootStatus($rootStatus)
    {
        ipsRegistry::$settings[$this->rootStatusKey] = $rootStatus;

        ipsRegistry::DB()->update( 'core_sys_conf_settings', array(
            'conf_value' => ipsRegistry::$settings[$this->rootStatusKey]
        ), "conf_key='$this->rootStatusKey'");
    }

    public function _md5($url)
    {
        $hash = md5($url);
        $result = '';

        for ($i = 0; $i < 32; $i+=2) {
            $digits = substr($hash, $i, 2);
            $number = hexdec($digits);
            $result.=chr($number);
        }

        return $result;
    }

    public function linkSubdomain($subdomain)
    {
        return $this->_performRequest(
            $this->apiHost . SURLY_API_SUBDOMAIN_LINK, 'POST',
                array(
                    'toolbar_id' => ipsRegistry::$settings['surly_toolbar_id'],
                    'password' => ipsRegistry::$settings['surly_toolbar_password'],
                    'subdomain' => $subdomain,
                )
            );
    }

    public function trackHistory($actionType)
    {
        $this->timeout = SURLY_API_TRACK_TIMEOUT;

        $this->_performRequest(
            $this->apiHost . SURLY_API_TRACK_HISTORY_PATH,  'POST',
                array(
                    'action_type' => $actionType,
                    'site_url' => ipsRegistry::$settings['_base_url'],
                    'toolbar_id' => ipsRegistry::$settings['surly_toolbar_id'],
                    'hash' => ipsRegistry::$settings['surly_activation_hash'],
                )
        );

        $this->timeout = SURLY_API_TIMEOUT;
    }
}
