<?php

// Make sure no one attempts to run this script "directly"
if (!defined('PUN'))
	exit;

// Tell admin_loader.php that this is indeed a plugin and that it is loaded
define('PUN_PLUGIN_LOADED', 1);

// Load language file
if (file_exists(PUN_ROOT . 'lang/' . $pun_user['language'] . '/surly.php')) {
	require_once PUN_ROOT . 'lang/' . $pun_user['language'] . '/surly.php';
} else {
	require_once PUN_ROOT . 'lang/English/surly.php';
}

define('SURLY_TAB_SETTINGS_PLUGIN', 'settings-plugin');
define('SURLY_TAB_SETTINGS_TOOLBAR', 'settings-toolbar');

define('SURLY_PANEL_URL', 'https://surdotly.com/settings/');
define('SURLY_PLUGIN_URL', 'admin_loader.php?plugin=AP_Surly.php');

require_once PUN_ROOT . 'include/surly/surly.php';

if (!defined('FORUM_CACHE_FUNCTIONS_LOADED')) {
	require PUN_ROOT . 'include/cache.php';
}

if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_toolbar_settings') {
	surly_save_toolbar_settings();
	surly_set_option('surly_initial', '2-1');

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_subdomain') {
	$result = surly_save_subdomain();

	if (isset($result['error'])) {
		header('Content-Type: application/json');
		echo json_encode(array('error' => $result['error']));
	} else {
		surly_set_option('surly_initial', '2-2');
		generate_config_cache();
	}

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_trusted_groups') {
	surly_save_trusted_groups();
	surly_set_option('surly_initial', '4-1');

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_shorten_urls') {
	surly_save_shorten_urls();
	surly_set_option('surly_initial', '4-2');	

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_replace_urls') {
	surly_save_replace_urls();
	surly_set_option('surly_initial', 0);	

	$surly = surly_get_sdk();
	$surly->trackHistory(SurlyFluxBB::SURLY_ACTION_TYPE_ACTIVATION);

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_skip_step') {
	surly_skip_step();

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_settings') {
	surly_save_replace_urls();
	surly_save_shorten_urls();
	surly_save_trusted_groups();

	$result = surly_save_subdomain();

	if (isset($result['error'])) {
		header('Content-Type: application/json');
		echo json_encode(array('error' => $result['error']));
	}

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_save_trusted_domain') {
	$result = surly_save_trusted_domain();

	if (isset($result['error'])) {
		header('Content-Type: application/json');
		echo json_encode(array('error' => $result['error']));
	} else if (isset($result['domain'])) {
		header('Content-Type: application/json');
		echo json_encode(array('domain' => $result['domain']));
	}

	generate_config_cache();

	exit();
}
else if (isset($_POST['action']) && $_POST['action'] == 'surly_ajax_delete_trusted_domains') {
	surly_delete_trusted_domains();

	generate_config_cache();

	exit();
}
else {
	// Display the admin navigation menu
	generate_admin_menu($plugin);

	if (surly_get_option('surly_initial', false))
	{
		require_once PUN_ROOT . implode(DIRECTORY_SEPARATOR, array('include', 'surly', 'template', 'surly-settings-initial.php'));
	}
	else if (surly_get_option('surly_toolbar_id', false))
	{
		if (isset($_GET['tab']) && $_GET['tab'] == SURLY_TAB_SETTINGS_TOOLBAR)
		{
			require_once PUN_ROOT . implode(DIRECTORY_SEPARATOR, array('include', 'surly', 'template', 'surly-settings-toolbar.php'));
		}
		else 
		{
			require_once PUN_ROOT . implode(DIRECTORY_SEPARATOR, array('include', 'surly', 'template', 'surly-settings-plugin.php'));
		}
	}
	else 
	{
		require_once PUN_ROOT . implode(DIRECTORY_SEPARATOR, array('include', 'surly', 'template', 'surly-settings-short.php'));
	}
}

function surly_save_subdomain()
{
	global $lang_surly;

	$surly_subdomain = isset($_POST['surly_subdomain']) ? trim($_POST['surly_subdomain']) : '';

	if ($surly_subdomain != surly_get_option('surly_subdomain', '')) {

		$surly = surly_get_sdk();

		if ($surly_subdomain == '') {

			$surly->trackHistory(SurlyFluxBB::SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK);
		} else {

			$result = json_decode($surly->linkSubdomain($surly_subdomain), true);

			if (isset($result['error_code'])) {

				$errors = array(
					1 => $lang_surly['invalid subdomain name'],
					2 => $lang_surly['is not subdomain, need valid subdomain'],
					3 => $lang_surly['subdomain already in use'],
					4 => $lang_surly['invalid cname record'],
					5 => $lang_surly['an unexpected error occured'],
				);

				return isset($errors[$result['error_code']])
					? array('error' => $errors[$result['error_code']]) : array('error' => $errors[5]);
			}
			elseif (isset($result['subdomain'])) {
				$surly_subdomain = $result['subdomain'];

				$surly->trackHistory(SurlyFluxBB::SURLY_ACTION_TYPE_SUBDOMAIN_LINK);
			}
			else {
				$surly_subdomain = surly_get_option('surly_subdomain', '');
			}
		}
	}

	surly_set_option('surly_subdomain', $surly_subdomain);
}

function surly_save_trusted_groups()
{
	$surly_trusted_groups = isset($_POST['surly_trusted_groups']) ? (array) $_POST['surly_trusted_groups'] : array();

	$groups = surly_get_groups();

	foreach ($surly_trusted_groups as $key => $value) {
		if (!isset($groups[$value])) {
			unset($surly_trusted_groups[$key]);
		}
	}

	surly_set_option('surly_trusted_groups', $surly_trusted_groups, true);
}

function surly_save_shorten_urls()
{
	$surly_shorten_urls = !empty($_POST['surly_shorten_urls']);

	surly_set_option('surly_shorten_urls', (int) $surly_shorten_urls);
}

function surly_save_replace_urls()
{
	$surly_replace_urls = isset($_POST['surly_replace_urls']) ? (array) $_POST['surly_replace_urls'] : array(0);
	$surly_replace_urls = array_intersect(array(0), $surly_replace_urls) ?: array_intersect(array(1), $surly_replace_urls) ?: array(0);

	surly_set_option('surly_replace_urls', $surly_replace_urls, true);
}

function surly_save_toolbar_settings()
{
	$surly_toolbar_id = isset($_POST['surly_toolbar_settings']['id']) ? $_POST['surly_toolbar_settings']['id'] : '';
	$surly_toolbar_password = isset($_POST['surly_toolbar_settings']['password']) ? $_POST['surly_toolbar_settings']['password'] : '';

	surly_set_option('surly_toolbar_id', $surly_toolbar_id);
	surly_set_option('surly_toolbar_password', $surly_toolbar_password);

	$surly = surly_get_sdk();
	$surly->trackHistory(SurlyFluxBB::SURLY_ACTION_TYPE_AUTH);
}

function surly_skip_step()
{
	$steps = array('1-0', '2-1', '2-2', '3-0', '4-1', '4-2');

	$next_step = isset($_POST['next_step']) && in_array($_POST['next_step'], $steps) ? $_POST['next_step'] : $steps[0];

	surly_set_option('surly_initial', $next_step);
}

function surly_save_trusted_domain()
{
	global $lang_surly;

	$trusted_domain = isset($_POST['surly_trusted_domain'])? preg_replace('/^https?:\/\/(.+)/',"$1", strtolower(trim($_POST['surly_trusted_domain']))) : '';

	if (empty($trusted_domain)) {
		return array('error' => $lang_surly['invalid domain name']);
	}

	if (preg_match('!(?P<host>(?:[a-z0-9_-]+\.)+[a-z]+)!u', $trusted_domain, $result)) {
		$trusted_domain = $result['host'];
	} else {
		return array('error' => $lang_surly['invalid domain name']);
	}

	if (in_array($trusted_domain, surly_get_option('surly_trusted_domains', array(), true))) {
		return array('error' => $lang_surly['domain exists']);
	}

	surly_set_option('surly_trusted_domains',
		array_merge(surly_get_option('surly_trusted_domains', array(), true), array($trusted_domain)),
		true
	);

	return array('domain' => $trusted_domain);
}

function surly_delete_trusted_domains()
{
	$trusted_domains = isset($_POST['surly_trusted_domains']) ? (array) $_POST['surly_trusted_domains'] : array();

	surly_set_option('surly_trusted_domains',		
		array_diff(surly_get_option('surly_trusted_domains', array(), true), $trusted_domains),
		true
	);
}