<?php

require_once 'SurlyFluxBB.php';

function surly_get_option($option, $default = false, $unserialize = false) {
	global $pun_config;

	$option = 'o_' . $option;

	if (isset($pun_config[$option])) {
		return $unserialize ? unserialize($pun_config[$option]) : $pun_config[$option];
	} else {
		return $default;
	}
}

function surly_set_option($option, $value, $serialize = false) {
	global $db;

	$option = 'o_' . $option;
	$value = $serialize ? serialize($value) : $value;

	$result = $db->query('SELECT * FROM ' . $db->prefix . "config WHERE conf_name='$option'")
		or error('Unable to fetch config', __FILE__, __LINE__, $db->error());

	if ($db->fetch_row($result)) {

		$db->query('UPDATE ' . $db->prefix . "config SET conf_value='$value' WHERE conf_name='$option'")
			or error('Unable to update the configuration', __FILE__, __LINE__, $db->error());
	} else {
		$db->query('INSERT INTO ' . $db->prefix . "config (conf_name, conf_value) VALUES('$option', '$value')")
			or error('Unable to insert into table ' . $db->prefix . 'config. Please check your configuration and try again', __FILE__, __LINE__, $db->error());
	}
}

function surly_get_groups() {
	global $db;

	$result = $db->query('SELECT g_id, g_title FROM ' . $db->prefix . 'groups WHERE g_id!=' . PUN_GUEST.' ORDER BY g_id')
		or error('Unable to fetch user group list', __FILE__, __LINE__, $db->error());

	$groups = array();

	while ($cur_group = $db->fetch_assoc($result))
	{
		$groups[$cur_group['g_id']] = pun_htmlspecialchars($cur_group['g_title']);
	}

	return $groups;
}


function surly_get_sdk() {
	static $surly;

	if (!isset($surly)) {

		$surly = new SurlyFluxBB(
			surly_get_option('surly_toolbar_id', SURLY_DEFAULT_TOOLBAR_ID),
			(bool) surly_get_option('surly_shorten_urls')
		);

		if (surly_get_option('surly_subdomain')) {
			$surly->setPanelHost(surly_get_option('surly_subdomain'));
		}

		foreach (surly_get_option('surly_trusted_domains', array(), true) as $domain) {
			$surly->whitelist($domain);
		}

        $site_url = parse_url(get_base_url());
        $surly->whitelist($site_url['host']);
	}

	return $surly;
}

function surly_replace($content, $groupId)
{
	if (in_array(1, surly_get_option('surly_replace_urls', array(0), true))) {

		$surly = surly_get_sdk();

		return in_array($groupId, surly_get_option('surly_trusted_groups', array(), true))
			? $content : $surly->process($content);
	}

	return $content;
}

function surly_replace_url($url, $groupId)
{
	if (in_array(1, surly_get_option('surly_replace_urls', array(0), true))) {

		$surly = surly_get_sdk();

		return in_array($groupId, surly_get_option('surly_trusted_groups', array(), true))
			? $url : $surly->processUrl($url);
	}

	return $url;
}