<?php

require_once implode(DIRECTORY_SEPARATOR, array('surly-sdk-php', 'surly', 'Surly.php'));

class SurlyFluxBB extends Surly
{
	const CMS_ID = 15;

	const SURLY_ACTION_TYPE_INSTALL = 1;
	const SURLY_ACTION_TYPE_AUTH = 2;
	const SURLY_ACTION_TYPE_ACTIVATION = 3;
	const SURLY_ACTION_TYPE_DEACTIVATION = 4;
	const SURLY_ACTION_TYPE_UNINSTALL = 5;
	const SURLY_ACTION_TYPE_SUBDOMAIN_LINK = 6;
	const SURLY_ACTION_TYPE_SUBDOMAIN_UNLINK = 7;

	protected $rootStatusKey = 'surly_root_status';
	public $isRootDomainAlive = null;

	public function cacheShortIds($url2shortIds)
	{
		global $db;

		if (!$url2shortIds) {
			return;
		}

		$insert = array();

		foreach ($url2shortIds as $longUrl => $shortId) {
			$hash = $this->hashLongUrl($longUrl);
			$insert[] =  "('" . $db->escape($longUrl) . "','" . $db->escape($hash) . "','" . $db->escape($shortId) . "')";
		}

		$db->query("INSERT IGNORE INTO `" . $db->prefix . 'shortener_cache' . "` (`long_url`,`hash`,`short_id`) VALUES " . implode(',',$insert));
	}

	public function getCachedShortIds($urls)
	{
		global $db;

		if (!$urls) {
			return array();
		}

		$where = array();

		foreach ($urls as $longUrl) {
			$hash = $this->hashLongUrl($longUrl);
			$where[] = "(`hash` = '" . $db->escape($hash) . "' AND `long_url` = '" . $db->escape($longUrl) . "')";
		}

		$result = $db->query("SELECT * FROM `" . $db->prefix . 'shortener_cache' . "` WHERE " . implode(' OR ', $where));

		$shortIds = array();

		while ($row = $db->fetch_assoc($result))
		{
			$shortIds[$row['long_url']] = $row['short_id'];
		}

		return $shortIds;
	}

	public function hashLongUrl($longUrl)
	{
		$hash = md5($longUrl);
		$result = '';

		for ($i = 0; $i < 32; $i+=2) {
			$digits = substr($hash, $i, 2);
			$number = hexdec($digits);

			$result .= chr($number);
		}

		return $result;
	}

	public function getCachedRootStatus()
	{
		return surly_get_option($this->rootStatusKey);
	}

	public function cacheRootStatus($rootStatus)
	{
		surly_set_option($this->rootStatusKey, $rootStatus);
	}

	public function trackHistory($actionType)
	{
		$this->timeout = SURLY_API_TRACK_TIMEOUT;

		$this->_performRequest(
			$this->apiHost . SURLY_API_TRACK_HISTORY_PATH,  'POST',
				array(
					'action_type' => $actionType,
					'site_url' => get_base_url(),
					'toolbar_id' => surly_get_option('surly_toolbar_id', null),
					'hash' => surly_get_option('surly_activation_hash'),
				)
		);

		$this->timeout = SURLY_API_TIMEOUT;
	}

	public function linkSubdomain($subdomain)
	{
		return $this->_performRequest(
			$this->apiHost . SURLY_API_SUBDOMAIN_LINK, 'POST',
				array(
					'toolbar_id' => surly_get_option('surly_toolbar_id'),
					'password' => surly_get_option('surly_toolbar_password'),
					'subdomain' => $subdomain,
				)
		);
	}
}
